/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.sms.SMSAddress;
import uk.co.mmscomputing.sms.SMSDataCodingScheme;
import uk.co.mmscomputing.sms.SMSTimeStamp;
import uk.co.mmscomputing.sms.SMSTransportProtocolDataUnit;

public class SMSStatusReport
extends SMSTransportProtocolDataUnit {
    public SMSStatusReport(InputStream inputStream) throws IOException {
        this.readFrom(inputStream);
    }

    public void readFrom(InputStream inputStream) throws IOException {
        int n = this.read(inputStream);
        this.put("TP-MTI", new Integer(n & 3));
        this.put("TP-MMS", new Boolean((n >> 2 & 1) == 0));
        this.put("TP-SRQ", new Boolean((n >> 5 & 1) == 0));
        this.put("TP-UDHI", new Boolean((n >> 6 & 1) != 0));
        this.put("TP-MR", new Integer(this.readInt(inputStream)));
        this.put("TP-RA", new SMSAddress(inputStream));
        this.put("TP-SCTS", new SMSTimeStamp(inputStream));
        this.put("TP-DT", new SMSTimeStamp(inputStream));
        this.put("TP-ST", new Integer(this.readOctet(inputStream)));
        int n2 = this.readOctet(false, inputStream);
        this.put("TP-PI", new Integer(n2));
        if ((n2 & 1) != 0) {
            this.put("TP-PID", new Integer(this.readOctet(inputStream)));
        }
        if ((n2 & 2) != 0) {
            this.put("TP-DCS", new SMSDataCodingScheme(this.readOctet(inputStream)));
        }
        if ((n2 & 4) != 0) {
            this.readUserDataFrom(inputStream);
        }
    }
}

