/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiEnumerator;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiServerApplication;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;
import uk.co.mmscomputing.device.capi.protocol.SpeechProtocol;
import uk.co.mmscomputing.device.capi.sound.PCMInputStream;
import uk.co.mmscomputing.device.capi.sound.PCMOutputStream;
import uk.co.mmscomputing.sms.SMSDLLEstablished;
import uk.co.mmscomputing.sms.SMSSCChannel;
import uk.co.mmscomputing.util.metadata.Metadata;
import uk.co.mmscomputing.util.metadata.MetadataListener;

public class SMSServiceCenter
implements MetadataListener,
Runnable {
    public static CapiMetadata md = new CapiMetadata();
    static SimpleDateFormat sdfd = new SimpleDateFormat("/yyyy/MM/dd/");
    static SimpleDateFormat sdff = new SimpleDateFormat("/yyyy/MM/dd/yyyyMMdd-HmsS");
    private CapiServerApplication server = null;

    private void answer(CapiChannel capiChannel, String string) throws IOException {
        final PCMInputStream pCMInputStream = capiChannel.getPCMInputStream();
        final PCMOutputStream pCMOutputStream = capiChannel.getPCMOutputStream();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SMSSCChannel sMSSCChannel = new SMSSCChannel(pCMOutputStream, pCMInputStream);
                try {
                    int n;
                    sMSSCChannel.send(new SMSDLLEstablished());
                    InputStream inputStream = sMSSCChannel.getInputStream();
                    byte[] byArray = new byte[256];
                    while ((n = inputStream.read(byArray)) != -1) {
                        System.out.println(new String(byArray, 0, n));
                    }
                }
                catch (Exception exception) {
                    System.out.println(this.getClass().getName() + ".answer:\n" + exception);
                    exception.printStackTrace();
                }
                finally {
                    try {
                        sMSSCChannel.close();
                    }
                    catch (IOException iOException) {
                        System.out.println(this.getClass().getName() + ".answer:\n" + iOException);
                    }
                }
            }
        }.start();
    }

    public void update(Object object, Metadata metadata) {
        if (object instanceof CapiMetadata.Indication) {
            this.handleIndication((CapiMetadata.Indication)object);
        } else if (object instanceof CapiException) {
            System.out.println(object);
        } else if (object instanceof Exception) {
            System.out.println(object);
            ((Exception)object).printStackTrace();
        }
    }

    public void handleIndication(CapiMetadata.Indication indication) {
        System.out.println("local  no = " + indication.localno);
        System.out.println("remote no = " + indication.remoteno);
        indication.setAccept(md.getInt("pickupTime"));
    }

    public void run() {
        System.out.println("running...");
        md.useMaxLogicalConnections(CapiEnumerator.getNoOfBChannels());
        md.useALaw();
        md.use64kBit();
        md.acceptAllCalls();
        md.useController(1);
        md.useLocalNo("0123456789");
        md.putInt("pickupTime", 1000);
        md.addListener(this);
        try {
            System.out.println("create server...");
            this.server = new CapiServerApplication(md);
            new Thread(this.server).start();
            while (true) {
                System.out.println("wait for call...");
                CapiChannel capiChannel = this.server.accept();
                if (capiChannel != null) {
                    System.out.println(sdff.format(new Date()) + ": accepted call...");
                    new File("uk/co/mmscomputing/sms" + sdfd.format(new Date())).mkdirs();
                    String string = capiChannel.getRemoteNo();
                    string = string.replaceAll("\\*\\*", "");
                    BProtocol bProtocol = capiChannel.getProtocol();
                    if (bProtocol instanceof SpeechProtocol) {
                        this.answer(capiChannel, "uk/co/mmscomputing/sms" + sdff.format(new Date()) + "-" + capiChannel.getLocalNo() + "-" + string + ".wav");
                        continue;
                    }
                    System.err.println("Unsupported protocol.");
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void RedirectSystemOut(String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            System.setOut(printStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void checkInput() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.equals("quit")) continue;
            this.server.close();
            break;
        }
        bufferedReader.close();
    }

    public static void main(String[] stringArray) {
        System.out.println(sdff.format(new Date()) + ": SMSServiceCenter");
        try {
            SMSServiceCenter sMSServiceCenter = new SMSServiceCenter();
            new Thread(sMSServiceCenter).start();
            sMSServiceCenter.checkInput();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

