/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.sms.SMSCommand;
import uk.co.mmscomputing.sms.SMSDLLError;
import uk.co.mmscomputing.sms.SMSDLLEstablished;
import uk.co.mmscomputing.sms.SMSDLLReleased;
import uk.co.mmscomputing.sms.SMSDataUnit;
import uk.co.mmscomputing.sms.SMSDataUnitListener;
import uk.co.mmscomputing.sms.SMSDeliverAckReport;
import uk.co.mmscomputing.sms.SMSDeliverErrReport;
import uk.co.mmscomputing.sms.SMSLandLineInputStream;
import uk.co.mmscomputing.sms.SMSLandLineOutputStream;
import uk.co.mmscomputing.sms.SMSSubmit;
import uk.co.mmscomputing.sms.SMSSubmitAckReport;

public class SMSSCChannel
implements SMSDataUnitListener {
    private static final int T12 = 4000;
    private SMSLandLineOutputStream out;
    private SMSLandLineInputStream in;
    private boolean isopen;
    private int errs = 0;
    private SMSDataUnit lastMsg = null;
    private boolean timedout;
    private Thread timer = null;
    private Semaphore blocker = new Semaphore(0, true);
    private int testSubmitError = 0;

    public SMSSCChannel(OutputStream outputStream, InputStream inputStream) {
        this.out = new SMSLandLineOutputStream(outputStream);
        this.in = new SMSLandLineInputStream(inputStream, this, false);
        this.isopen = true;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    private void setTimer() {
        if (this.timer == null) {
            this.timer = new Thread(){

                public void run() {
                    try {
                        while (SMSSCChannel.this.isopen) {
                            SMSSCChannel.this.timedout = true;
                            SMSSCChannel.this.blocker.tryAcquire(4000L, TimeUnit.MILLISECONDS);
                            if (!SMSSCChannel.this.timedout) continue;
                            System.out.println(this.getClass().getName() + ".run:\nTransfer timed out.");
                            SMSSCChannel.this.send(new SMSDLLReleased());
                            SMSSCChannel.this.close();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        System.err.println(this.getClass().getName() + ".run:\n" + exception);
                    }
                    SMSSCChannel.this.timer = null;
                }
            };
            this.timer.start();
        }
    }

    private void resetTimer() {
        this.timedout = false;
        this.blocker.release();
    }

    public void send(SMSDataUnit sMSDataUnit) throws IOException {
        if (this.isopen) {
            this.lastMsg = sMSDataUnit;
            sMSDataUnit.writeTo(this.out);
            this.resetTimer();
        }
    }

    public void received(SMSDataUnit sMSDataUnit) throws IOException {
        System.err.println(sMSDataUnit.toString());
        this.resetTimer();
        if (sMSDataUnit instanceof SMSDLLEstablished) {
            this.errs = 0;
        } else if (sMSDataUnit instanceof SMSDLLError) {
            ++this.errs;
            if (this.errs < 2) {
                this.send(this.lastMsg);
            } else {
                this.send(new SMSDLLReleased());
                this.close();
            }
        } else if (sMSDataUnit instanceof SMSDLLReleased) {
            this.close();
        } else {
            this.errs = 0;
            if (sMSDataUnit instanceof SMSSubmit) {
                this.send(new SMSSubmitAckReport());
            } else if (sMSDataUnit instanceof SMSCommand) {
                this.send(new SMSSubmitAckReport());
            } else if (!(sMSDataUnit instanceof SMSDeliverAckReport) && sMSDataUnit instanceof SMSDeliverErrReport) {
                this.send(new SMSDLLReleased());
                this.close();
            }
        }
    }

    public void close() throws IOException {
        if (this.isopen) {
            this.isopen = false;
            this.errs = 0;
            this.resetTimer();
            this.out.close();
            this.in.close();
        }
    }
}

