/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.sms.SMSAddress;
import uk.co.mmscomputing.sms.SMSDLLEstablished;
import uk.co.mmscomputing.sms.SMSDataUnit;
import uk.co.mmscomputing.sms.SMSDataUnitListener;
import uk.co.mmscomputing.sms.SMSSCChannel;
import uk.co.mmscomputing.sms.SMSStatusReport;
import uk.co.mmscomputing.sms.SMSSubmit;

public class SMSSCCapiReceiver
implements SMSDataUnitListener,
Runnable {
    private CapiChannel capichannel = null;
    private SMSSCChannel smschannel = null;

    public SMSSCCapiReceiver(CapiChannel capiChannel) {
        this.capichannel = capiChannel;
    }

    public void send(SMSDataUnit sMSDataUnit) throws IOException {
        this.smschannel.send(sMSDataUnit);
    }

    public void received(SMSDataUnit sMSDataUnit) throws IOException {
        if (sMSDataUnit instanceof SMSSubmit) {
            System.out.println(sMSDataUnit);
            SMSAddress sMSAddress = (SMSAddress)sMSDataUnit.get("TP-DA");
            byte[] byArray = sMSDataUnit.getUserData();
        } else if (sMSDataUnit instanceof SMSStatusReport) {
            System.out.println(sMSDataUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            int n;
            this.smschannel = new SMSSCChannel(this.capichannel.getPCMOutputStream(), this.capichannel.getPCMInputStream());
            this.send(new SMSDLLEstablished());
            InputStream inputStream = this.smschannel.getInputStream();
            byte[] byArray = new byte[256];
            while ((n = inputStream.read(byArray)) != -1) {
                System.out.println(new String(byArray, 0, n));
            }
        }
        catch (Exception exception) {
            System.out.println("3\b" + this.getClass().getName() + ".run:\n\t" + exception);
        }
        finally {
            try {
                if (this.smschannel != null) {
                    this.smschannel.close();
                }
                if (this.capichannel != null) {
                    this.capichannel.close();
                }
            }
            catch (Exception exception) {
                System.out.println("3\b" + this.getClass().getName() + ".run:\n\t" + exception);
            }
        }
    }
}

