/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.dsp.phone.FSKOutputStream;

public class SMSLandLineOutputStream
extends FilterOutputStream {
    private static int T10 = 300;
    private byte[] bytes = new byte[178];
    private int count = 0;

    public SMSLandLineOutputStream(OutputStream outputStream) {
        super(new FSKOutputStream(outputStream));
    }

    private void writeChecksum() throws IOException {
        int n = 0;
        for (int i = 0; i < this.count; ++i) {
            n += this.bytes[i] & 0xFF;
        }
        n = -n & 0xFF;
        this.out.write(n);
    }

    protected void writeMessage(boolean bl) throws IOException {
        if (this.bytes[0] == 19) {
            ((FSKOutputStream)this.out).writeDelay(T10);
        } else {
            ((FSKOutputStream)this.out).writeDelay(100);
        }
        ((FSKOutputStream)this.out).writeMarkSignal(80);
        this.bytes[0] = bl ? (byte)(this.bytes[0] & 0x7F) : (byte)(this.bytes[0] | 0xFFFFFF80);
        this.bytes[1] = (byte)(this.count - 2);
        this.out.write(this.bytes, 0, this.count);
        this.writeChecksum();
        ((FSKOutputStream)this.out).writeBits(-1, 10);
    }

    public void write(int n) throws IOException {
        if (this.count == this.bytes.length) {
            this.writeMessage(true);
            this.count = 2;
        }
        this.bytes[this.count++] = (byte)n;
        if (this.count == 1) {
            ++this.count;
        }
    }

    public void flush() throws IOException {
        if (this.count > 0) {
            this.writeMessage(false);
            this.count = 0;
        }
        this.out.flush();
    }
}

