/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.sms.SMSTransportProtocolParameter;

public class SMSDataCodingScheme
extends SMSTransportProtocolParameter {
    private int flags;
    private int msggroup = -1;
    private int msgcoding = -1;
    private int msgclass = -1;
    private boolean msgcompression = false;

    public SMSDataCodingScheme(int n) {
        this.flags = n & 0xFF;
        this.msggroup = n >> 6 & 3;
        switch (this.msggroup) {
            case 0: {
                this.group0(n);
                break;
            }
            case 1: {
                this.group1(n);
                break;
            }
            case 2: {
                this.group2(n);
                break;
            }
            case 3: {
                this.group3(n);
            }
        }
    }

    public void group0(int n) {
        boolean bl = this.msgcompression = (n >> 5 & 1) == 1;
        if (!this.msgcompression) {
            this.msgcoding = n >> 2 & 3;
        }
        if ((n >> 4 & 1) == 1) {
            this.msgclass = n & 3;
        }
    }

    public void group1(int n) {
        boolean bl = this.msgcompression = (n >> 5 & 1) == 1;
        if (!this.msgcompression) {
            this.msgcoding = n >> 2 & 3;
        }
        if ((n >> 4 & 1) == 1) {
            this.msgclass = n & 3;
        }
    }

    public void group2(int n) {
    }

    public void group3(int n) {
        this.msggroup = n >> 4 & 0xF;
        switch (n >> 4 & 3) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.msgcoding = n >> 2 & 1;
                this.msgclass = n & 3;
            }
        }
    }

    public int getCoding() {
        return this.msgcoding;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.flags);
    }

    public String toString() {
        String string = this.getClass().getName() + ":\n";
        string = string + "flags       = " + Integer.toBinaryString(this.flags) + "b\n";
        switch (this.msggroup) {
            case 0: {
                string = string + "General Data Coding indication\n";
                break;
            }
            case 1: {
                string = string + "Message Marked for Automatic Deletion Group\n";
                break;
            }
            case 2: {
                string = string + "Reserved coding groups\n";
                break;
            }
            case 12: {
                string = string + "Message Waiting Indication Group: Discard Message\n";
                break;
            }
            case 13: {
                string = string + "Message Waiting Indication Group: Store Message\n";
                break;
            }
            case 14: {
                string = string + "Message Waiting Indication Group: Store Message\n";
                break;
            }
            case 15: {
                string = string + "Data coding/message class\n";
            }
        }
        switch (this.msgcoding) {
            case 0: {
                string = string + "GSM 7 bit default alphabet\n";
                break;
            }
            case 1: {
                string = string + "8 bit data\n";
                break;
            }
            case 2: {
                string = string + "UCS2 (16bit)\n";
                break;
            }
            case 3: {
                string = string + "Reserved\n";
            }
        }
        switch (this.msgclass) {
            case 0: {
                string = string + "Class 0: Display message immediately on ME screen.\n";
                break;
            }
            case 1: {
                string = string + "Class 1: Default meaning: ME-specific\n";
                break;
            }
            case 2: {
                string = string + "Class 2: (U)SIM-specific message\n";
                break;
            }
            case 3: {
                string = string + "Class 3: Default meaning: TE specific (see 3GPP TS 27.005)\n";
            }
        }
        if (this.msgcompression) {
            string = string + "Use compression algorithm defined in 3GPP TS 23.042\n";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(new SMSDataCodingScheme(Integer.parseInt(stringArray[0], 16)).toString());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

