/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.sms.SMSNibbleInputStream;
import uk.co.mmscomputing.sms.SMSNibbleOutputStream;
import uk.co.mmscomputing.sms.SMSTransportProtocolParameter;

public class SMSAddress
extends SMSTransportProtocolParameter {
    private int numberingPlan = 0;
    private int typeOfNumber = 0;
    private byte[] number;

    public SMSAddress(InputStream inputStream) throws IOException {
        int n = this.read(inputStream);
        this.numberingPlan = this.read(inputStream);
        this.typeOfNumber = this.numberingPlan >> 4 & 7;
        this.numberingPlan &= 0xF;
        this.number = new byte[n];
        if (n != new SMSNibbleInputStream(inputStream).read(this.number)) {
            throw new IOException(this.getClass().getName() + "<init>:\nUnexpected EOF. Could not read whole number.");
        }
    }

    public SMSAddress(int n, int n2, byte[] byArray) {
        this.numberingPlan = n;
        this.typeOfNumber = n2;
        this.number = byArray;
    }

    public SMSAddress(int n, int n2, String string) {
        this(n, n2, string.getBytes());
    }

    public SMSAddress(String string) {
        this(1, 0, string.getBytes());
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.number.length);
        outputStream.write(0x80 | this.typeOfNumber << 4 | this.numberingPlan);
        outputStream = new SMSNibbleOutputStream(outputStream);
        outputStream.write(this.number);
        outputStream.flush();
    }

    public String getTypeOfNumberString() {
        switch (this.typeOfNumber) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "International number";
            }
            case 2: {
                return "National number";
            }
            case 3: {
                return "Network specific number";
            }
            case 4: {
                return "Subscriber number";
            }
            case 5: {
                return "Alphanumeric, (coded according to 3GPP TS 23.038 [9] GSM 7-bit default alphabet)";
            }
            case 6: {
                return "Abbreviated number";
            }
        }
        return "Reserved for extension";
    }

    public String getNumberingPlanString() {
        switch (this.numberingPlan) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "ISDN/telephone numbering plan (E.164/E.163)";
            }
            case 3: {
                return "Data numbering plan (X.121)";
            }
            case 4: {
                return "Telex numbering plan";
            }
            case 5: {
                return "Service Centre Specific plan (5)";
            }
            case 6: {
                return "Service Centre Specific plan (6)";
            }
            case 8: {
                return "National numbering plan";
            }
            case 9: {
                return "Private numbering plan";
            }
            case 10: {
                return "ERMES numbering plan (ETSI DE/PS 3 01-3)";
            }
        }
        return "Reserved for extension";
    }

    public String getNumber() {
        return new String(this.number);
    }

    public String toString() {
        String string = this.getClass().getName() + ":\n";
        string = string + "numbering plan = " + this.getNumberingPlanString() + "\n";
        string = string + "type of number = " + this.getTypeOfNumberString() + "\n";
        string = string + "number         = " + this.getNumber() + "\n";
        return string;
    }
}

