/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.sms.SMS7BitInputStream;

public class SMS7BitOutputStream
extends FilterOutputStream {
    private int bitbuf = 0;
    private int bitCount = 0;

    public SMS7BitOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        this.bitbuf |= (n & 0x7F) << this.bitCount;
        this.bitCount += 7;
        while (this.bitCount >= 8) {
            n = this.bitbuf & 0xFF;
            this.bitCount -= 8;
            this.bitbuf >>= 8;
            this.out.write(n);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    public void flush() throws IOException {
        if (this.bitCount > 0) {
            this.write(-1);
            this.bitCount = 0;
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "Hello Michael";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            SMS7BitOutputStream sMS7BitOutputStream = new SMS7BitOutputStream(byteArrayOutputStream);
            sMS7BitOutputStream.write(string.getBytes());
            sMS7BitOutputStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            SMS7BitInputStream sMS7BitInputStream = new SMS7BitInputStream(byteArrayInputStream);
            byte[] byArray = new byte[256];
            int n = sMS7BitInputStream.read(byArray);
            System.err.println("len = " + n);
            System.err.println(new String(byArray, 0, n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

