/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SMS7BitInputStream
extends FilterInputStream {
    private int bitbuf = 0;
    private int bitCount = 0;

    public SMS7BitInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        int n;
        if (this.bitCount < 7) {
            n = super.read();
            if (n == -1) {
                return -1;
            }
            this.bitbuf |= (n & 0xFF) << this.bitCount;
            this.bitCount += 8;
        }
        n = this.bitbuf & 0x7F;
        this.bitCount -= 7;
        this.bitbuf >>= 7;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (byArray == null) {
            throw new NullPointerException(this.getClass().getName() + ".read(byte[] buf, int off, int len): buf is null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".read(byte[] buf, int off, int len): index off [" + n + "] or len [" + n2 + "] out of bounds [" + byArray.length + "].");
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = this.read();
            if (n4 == -1) {
                return n3 == 0 ? -1 : n3;
            }
            byArray[n++] = (byte)n4;
        }
        return n3;
    }

    public static void main(String[] stringArray) {
        try {
            byte[] byArray = new byte[]{-56, 50, -101, -3, 102, -127, -18, 111, 57, -101, 12};
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            SMS7BitInputStream sMS7BitInputStream = new SMS7BitInputStream(byteArrayInputStream);
            byArray = new byte[256];
            int n = sMS7BitInputStream.read(byArray);
            System.err.println("len = " + n);
            System.err.println(new String(byArray, 0, n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

