/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.math;

public class Rational
extends Number {
    private int numerator;
    private int denominator;

    public Rational(int n) {
        this.numerator = n;
        this.denominator = 1;
    }

    public Rational(double d) {
        this.set(d);
    }

    public Rational(String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length == 2) {
            this.numerator = Integer.parseInt(stringArray[0]);
            this.denominator = Integer.parseInt(stringArray[1]);
            this.gcd();
        } else {
            this.set(new Double(string));
        }
    }

    public Rational(int n, int n2) throws IllegalArgumentException {
        this.numerator = n;
        this.denominator = n2;
        this.gcd();
    }

    public void set(double d) {
        long l = 0L;
        long l2 = 1L;
        double d2 = Math.abs(d);
        if (d2 > 1.0E-8) {
            long l3;
            double d3 = d2;
            l = l3 = (long)d3;
            long l4 = 1L;
            long l5 = 0L;
            while (1.0E7 * Math.abs(d2 * (double)l2 - (double)l) > d2 * (double)l2) {
                d3 = 1.0 / (d3 - (double)l3);
                l3 = (long)d3;
                long l6 = l3 * l + l4;
                l4 = l;
                l = l6;
                l6 = l3 * l2 + l5;
                l5 = l2;
                l2 = l6;
                if (!((double)l2 > 1.0E7) && !((double)(l * l2) > 1.0E9)) continue;
                l = l4 / l5;
                l2 = 1L;
                d2 = l;
            }
        }
        if (d < 0.0) {
            l = -l;
        }
        this.numerator = (int)l;
        this.denominator = (int)l2;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void gcd() {
        long l = Rational.getGCD(this.numerator, this.denominator);
        this.numerator = (int)((long)this.numerator / l);
        this.denominator = (int)((long)this.denominator / l);
    }

    public static long getGCD(long l, long l2) {
        long l3;
        if (l2 == 0L) {
            throw new IllegalArgumentException();
        }
        if ((l = Math.abs(l)) == 0L) {
            return 1L;
        }
        if ((l2 = Math.abs(l2)) == 0L) {
            return 1L;
        }
        if (l < l2) {
            l3 = l;
            l = l2;
            l2 = l3;
        }
        do {
            l3 = l % l2;
            l = l2;
            l2 = l3;
        } while (l3 > 0L);
        return l;
    }

    public byte byteValue() {
        return (byte)(this.numerator / this.denominator);
    }

    public short shortValue() {
        return (short)(this.numerator / this.denominator);
    }

    public int intValue() {
        return this.numerator / this.denominator;
    }

    public long longValue() {
        return this.numerator / this.denominator;
    }

    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public String toString() {
        return "" + this.numerator + "/" + this.denominator;
    }

    public static Rational valueOf(int n) {
        return new Rational(n);
    }

    public static Rational valueOf(double d) {
        return new Rational(d);
    }

    public static Rational valueOf(String string) {
        return new Rational(string);
    }

    public static Rational valueOf(Rational rational) {
        return new Rational(rational.getNumerator(), rational.getDenominator());
    }

    public Rational negate() {
        return new Rational(-this.numerator, this.denominator);
    }

    public Rational inverse() {
        return new Rational(this.denominator, this.numerator);
    }

    public Rational add(Rational rational) {
        int n = this.numerator * rational.getDenominator();
        int n2 = this.denominator * rational.getNumerator();
        int n3 = this.denominator * rational.getDenominator();
        return new Rational(n + n2, n3);
    }

    public Rational sub(Rational rational) {
        int n = this.numerator * rational.getDenominator();
        int n2 = this.denominator * rational.getNumerator();
        int n3 = this.denominator * rational.getDenominator();
        return new Rational(n - n2, n3);
    }

    public Rational mul(Rational rational) {
        int n = this.numerator * rational.getNumerator();
        int n2 = this.denominator * rational.getDenominator();
        return new Rational(n, n2);
    }

    public Rational div(Rational rational) {
        int n = this.numerator * rational.getDenominator();
        int n2 = this.denominator * rational.getNumerator();
        return new Rational(n, n2);
    }

    public static void main(String[] stringArray) {
        Rational rational = new Rational(5, 7);
        System.out.println("a=" + rational);
        Rational rational2 = new Rational("13/7");
        System.out.println("b=" + rational2);
        Rational rational3 = rational.div(rational2);
        System.out.println(rational3);
    }
}

