/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RLEOutputStream
extends FilterOutputStream {
    private int ccw;
    private int rlen;
    private int bpcw;
    private int cw;
    private int cwi;

    public RLEOutputStream(OutputStream outputStream) {
        this(outputStream, 1);
    }

    public RLEOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.bpcw = n;
        this.cw = 0;
        this.cwi = 0;
        this.ccw = -1;
        this.rlen = 0;
    }

    public void setStartCodeWord(int n) {
        this.ccw = n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.cw <<= 8;
            this.cw |= byArray[n + i] & 0xFF;
            ++this.cwi;
            if (this.cwi != this.bpcw) continue;
            this.write(this.cw);
            this.cw = 0;
            this.cwi = 0;
        }
    }

    public void write(int n) throws IOException {
        if (n == this.ccw) {
            ++this.rlen;
        } else {
            this.out.write(this.rlen);
            this.ccw = n;
            this.rlen = 1;
        }
    }

    public void flush() throws IOException {
        if (this.rlen > 0) {
            this.out.write(this.rlen);
        }
        this.ccw = -1;
        this.rlen = 0;
        this.out.flush();
    }
}

