/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RLEInputStream
extends FilterInputStream {
    private int rlen;
    private int ccwi;
    private int[] c = new int[2];
    private int bpcw;
    private int cwi;
    private byte[][] ccw = new byte[2][4];

    public RLEInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 1);
    }

    public RLEInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.setCodeWords(0xFFFFFF, 0);
        this.bpcw = n;
        this.resetToStartCodeWord();
    }

    public void setCodeWords(int n, int n2) {
        if (n == -1) {
            --n;
        }
        if (n2 == -1) {
            // empty if block
        }
        this.c[0] = n;
        this.ccw[0][0] = (byte)(n & 0xFF);
        this.ccw[0][1] = (byte)(n >> 8 & 0xFF);
        this.ccw[0][2] = (byte)(n >> 16 & 0xFF);
        this.ccw[0][3] = (byte)(n >> 24 & 0xFF);
        this.c[1] = --n2;
        this.ccw[1][0] = (byte)(n2 & 0xFF);
        this.ccw[1][1] = (byte)(n2 >> 8 & 0xFF);
        this.ccw[1][2] = (byte)(n2 >> 16 & 0xFF);
        this.ccw[1][3] = (byte)(n2 >> 24 & 0xFF);
    }

    public void resetToStartCodeWord() {
        this.ccwi = -1;
        this.cwi = 0;
        this.rlen = 0;
    }

    public int read() throws IOException {
        while (this.rlen == 0) {
            this.rlen = this.in.read();
            if (this.rlen == -1) {
                return -1;
            }
            this.ccwi = this.ccwi + 1 & 1;
        }
        --this.rlen;
        return this.c[this.ccwi];
    }

    private int pread() throws IOException {
        while (this.rlen == 0) {
            this.rlen = this.in.read();
            if (this.rlen == -1) {
                return -1;
            }
            this.ccwi = this.ccwi + 1 & 1;
        }
        byte by = this.ccw[this.ccwi][this.cwi];
        ++this.cwi;
        if (this.cwi == this.bpcw) {
            this.cwi = 0;
            --this.rlen;
        }
        return by & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException(this.getClass().getName() + ".read(byte[] b, int off, int len): b is null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".read(byte[] b, int off, int len): index off or len out of bounds.");
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = this.pread();
            if (n3 == -1) {
                return i == 0 ? -1 : i;
            }
            byArray[n + i] = (byte)n3;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        try {
            byte[] byArray = new byte[]{2, 4, 9};
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            RLEInputStream rLEInputStream = new RLEInputStream(byteArrayInputStream, 3);
            rLEInputStream.setCodeWords(0xCCBBAA, 0x332211);
            byArray = new byte[50];
            int n = rLEInputStream.read(byArray);
            for (int i = 0; i < n; ++i) {
                System.out.println("[" + i + "]=" + Integer.toHexString(byArray[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

