/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RLEBitOutputStream
extends FilterOutputStream {
    private int ccw = -1;
    private int rlen = 0;
    private int bpcw = 8;

    public RLEBitOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void setBitsPerCodeWord(int n) {
        this.bpcw = n;
    }

    public void setStartCodeWord(int n) {
        this.ccw = n;
        this.rlen = 0;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i] & 0xFF);
        }
    }

    public void writeBits(int n, int n2, int n3) throws IOException {
        switch (this.bpcw) {
            case 1: {
                for (int i = n2; i >= n3; --i) {
                    this.write8(n >> i & 1);
                }
                break;
            }
            case 2: {
                for (int i = n2; i >= n3; --i) {
                    this.write8(n >> (i << 1) & 3);
                }
                break;
            }
            case 4: {
                for (int i = n2; i >= n3; --i) {
                    this.write8(n >> (i << 2) & 0xF);
                }
                break;
            }
            default: {
                for (int i = n2; i >= n3; --i) {
                    this.write8(n);
                }
            }
        }
    }

    public void write(int n) throws IOException {
        switch (this.bpcw) {
            case 1: {
                this.write1(n);
                break;
            }
            case 2: {
                this.write2(n);
                break;
            }
            case 4: {
                this.write4(n);
                break;
            }
            default: {
                this.write8(n);
            }
        }
    }

    private void write1(int n) throws IOException {
        this.write8(n >> 7 & 1);
        this.write8(n >> 6 & 1);
        this.write8(n >> 5 & 1);
        this.write8(n >> 4 & 1);
        this.write8(n >> 3 & 1);
        this.write8(n >> 2 & 1);
        this.write8(n >> 1 & 1);
        this.write8(n & 1);
    }

    private void write2(int n) throws IOException {
        this.write8(n >> 6 & 3);
        this.write8(n >> 4 & 3);
        this.write8(n >> 2 & 3);
        this.write8(n & 3);
    }

    private void write4(int n) throws IOException {
        this.write8(n >> 4 & 0xF);
        this.write8(n & 0xF);
    }

    private void write8(int n) throws IOException {
        if (n == this.ccw) {
            ++this.rlen;
        } else {
            this.out.write(this.rlen);
            this.ccw = n;
            this.rlen = 1;
        }
    }

    public void flush() throws IOException {
        if (this.rlen > 0) {
            this.out.write(this.rlen);
        }
        this.ccw = -1;
        this.rlen = 0;
        this.out.flush();
    }
}

