/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.io.BitSwapTable;

public class BitSwapInputStream
extends FilterInputStream
implements BitSwapTable {
    public BitSwapInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            return -1;
        }
        n = bitSwapTable[n];
        return n & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        for (int i = 0; i < n; ++i) {
            byArray[i] = bitSwapTable[byArray[i] & 0xFF];
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        n2 = this.in.read(byArray, n, n2);
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = bitSwapTable[byArray[n + i] & 0xFF];
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < 256; ++i) {
                byteArrayOutputStream.write(i);
            }
            BitSwapInputStream bitSwapInputStream = new BitSwapInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            for (int i = 0; i < 256; ++i) {
                int n = ((InputStream)bitSwapInputStream).read();
                String string = Integer.toBinaryString(i);
                while (string.length() < 8) {
                    string = "0" + string;
                }
                String string2 = Integer.toBinaryString(n);
                while (string2.length() < 8) {
                    string2 = "0" + string2;
                }
                System.out.println(" " + string + " " + string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

