/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends FilterOutputStream {
    private int buf = 0;
    private int off = 0;
    protected int count = 0;

    public BitOutputStream() {
        this(new ByteArrayOutputStream());
    }

    public BitOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    protected void cbLength(int n) throws IOException {
    }

    public void write(int n) throws IOException {
        this.write(n &= 1, 1);
    }

    public void write(int n, int n2) throws IOException {
        n2 += this.off;
        this.buf |= (n <<= this.off);
        while (n2 >= 8) {
            super.write(this.buf & 0xFF);
            this.buf >>= 8;
            n2 -= 8;
            this.cbLength(++this.count);
        }
        this.off = n2 & 7;
    }

    public void pad() throws IOException {
        if (this.off > 0) {
            this.write(0, 8);
        }
        this.buf = 0;
        this.off = 0;
        this.count = 0;
    }

    public void flush() throws IOException {
        this.pad();
        super.flush();
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public byte[] toByteArray() throws IOException {
        if (this.out instanceof ByteArrayOutputStream) {
            super.flush();
            return ((ByteArrayOutputStream)this.out).toByteArray();
        }
        throw new IOException("mmsc - BitOutputStream cannot convert underlying output stream to array of bytes !");
    }

    public void reset() throws IOException {
        this.count = 0;
        if (!(this.out instanceof ByteArrayOutputStream)) {
            throw new IOException("mmsc - BitOutputStream cannot reset underlying output stream !");
        }
        ((ByteArrayOutputStream)this.out).reset();
    }
}

