/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends FilterInputStream {
    private int buf = 0;
    private int bitsAvail = 0;
    private boolean eof = false;
    protected int count = 0;
    protected boolean nextByteMoreSignificant;

    public BitInputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.nextByteMoreSignificant = bl;
    }

    public BitInputStream(InputStream inputStream) {
        this(inputStream, true);
    }

    public void setNextByteMoreSignificant(boolean bl) {
        this.nextByteMoreSignificant = bl;
    }

    public void reset() throws IOException {
        super.reset();
        this.bitsAvail = 0;
        this.buf = 0;
        this.eof = false;
        this.count = 0;
    }

    public int availableBits() {
        if (this.eof && this.bitsAvail <= 0) {
            return -1;
        }
        return this.bitsAvail;
    }

    public void skipPadding(int n) throws IOException {
        this.clrBits(this.bitsAvail % n);
    }

    public int readBit() throws IOException {
        if (this.eof && this.bitsAvail <= 0) {
            return -1;
        }
        this.needBits(1);
        int n = this.getBits(1);
        this.clrBits(1);
        return n;
    }

    public int readBits(int n) throws IOException {
        if (this.eof && this.bitsAvail <= 0) {
            return -1;
        }
        if (n == 0) {
            return 0;
        }
        this.needBits(n);
        int n2 = this.getBits(n);
        this.clrBits(n);
        return n2;
    }

    protected int cbCount() throws IOException {
        return this.in.read();
    }

    public void needBits(int n) throws IOException {
        while (!this.eof && this.bitsAvail < n) {
            int n2 = this.cbCount();
            if (n2 == -1) {
                this.eof = true;
                break;
            }
            ++this.count;
            this.buf |= this.nextByteMoreSignificant ? n2 << this.bitsAvail : (n2 &= 0xFF) << 24 - this.bitsAvail;
            this.bitsAvail += 8;
        }
    }

    protected void clrBits(int n) {
        this.bitsAvail -= n;
        this.buf = this.nextByteMoreSignificant ? (this.buf >>>= n) : (this.buf <<= n);
    }

    protected int getBits(int n) {
        n = 32 - n;
        return this.nextByteMoreSignificant ? this.buf << n >>> n : this.buf >>> n;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            byte[] byArray = new byte[]{-103, -120, -103};
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BitInputStream bitInputStream = new BitInputStream(byteArrayInputStream, true);
            System.out.println("\nnextByteMoreSignificant = true");
            while ((n = bitInputStream.readBits(9)) != -1) {
                System.out.println("code= " + Integer.toBinaryString(n));
            }
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            bitInputStream = new BitInputStream(byteArrayInputStream, false);
            System.out.println("\nnextByteMoreSignificant = false");
            while ((n = bitInputStream.readBits(9)) != -1) {
                System.out.println("code= " + Integer.toBinaryString(n));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

