/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.io.Base64Table;

public class Base64InputStream
extends FilterInputStream
implements Base64Table {
    private int position = 3;
    private int lineLength = -1;
    private byte[] b3 = new byte[3];
    private byte[] b4 = new byte[4];

    public Base64InputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        ++this.lineLength;
        if (this.lineLength == 76) {
            this.lineLength = 0;
            return 10;
        }
        ++this.position;
        if (this.position >= 4) {
            int n = this.in.read(this.b3);
            if (n == -1) {
                return -1;
            }
            this.encode(this.b4, this.b3, n);
            this.position = 0;
        }
        return this.b4[this.position];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException(this.getClass().getName() + ".read(byte[] b, int off, int len): b is null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".read(byte[] b, int off, int len): index off or len out of bounds.");
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                return i == 0 ? -1 : i;
            }
            byArray[n + i] = (byte)n3;
        }
        return n2;
    }

    private void encode(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        switch (n) {
            case 3: {
                n2 = (byArray2[0] & 0xFF) << 16;
                n2 += (byArray2[1] & 0xFF) << 8;
                byArray[0] = encodeTable[(n2 += byArray2[2] & 0xFF) >> 18];
                byArray[1] = encodeTable[n2 >> 12 & 0x3F];
                byArray[2] = encodeTable[n2 >> 6 & 0x3F];
                byArray[3] = encodeTable[n2 & 0x3F];
                break;
            }
            case 2: {
                n2 = (byArray2[0] & 0xFF) << 16;
                byArray[0] = encodeTable[(n2 += (byArray2[1] & 0xFF) << 8) >> 18];
                byArray[1] = encodeTable[n2 >> 12 & 0x3F];
                byArray[2] = encodeTable[n2 >> 6 & 0x3F];
                byArray[3] = 61;
                break;
            }
            case 1: {
                n2 = (byArray2[0] & 0xFF) << 16;
                byArray[0] = encodeTable[n2 >> 18];
                byArray[1] = encodeTable[n2 >> 12 & 0x3F];
                byArray[2] = 61;
                byArray[3] = 61;
            }
        }
    }

    public static byte[] encode(String string) throws IOException {
        return Base64InputStream.encode(string.getBytes());
    }

    public static byte[] encode(byte[] byArray) throws IOException {
        return Base64InputStream.encode(new ByteArrayInputStream(byArray));
    }

    public static byte[] encode(InputStream inputStream) throws IOException {
        return Base64InputStream.encode(inputStream, 256);
    }

    public static byte[] encode(InputStream inputStream, int n) throws IOException {
        int n2;
        Base64InputStream base64InputStream = new Base64InputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[n];
        while ((n2 = base64InputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void main(String[] stringArray) {
        try {
            byte[] byArray = Base64InputStream.encode("Important Message!!");
            System.out.print(new String(byArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

