/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.io.IOException;
import uk.co.mmscomputing.io.IntFilterInputStream;

public class TIFFYCbCrInputStream
extends IntFilterInputStream {
    protected double LumaRed;
    protected double LumaGreen;
    protected double LumaBlue;
    protected double RfBY;
    protected double RfBCb;
    protected double RfBCr;
    protected double RfWY;
    protected double RfWCb;
    protected double RfWCr;
    private double RCr;
    private double BCb;
    private double GY;
    private double GB;
    private double GR;

    public TIFFYCbCrInputStream(IntFilterInputStream intFilterInputStream) throws IOException {
        super(intFilterInputStream);
    }

    public void setColourCoefficients(double d, double d2, double d3) {
        this.LumaRed = d;
        this.LumaGreen = d2;
        this.LumaBlue = d3;
        this.RCr = 2.0 - 2.0 * d;
        this.BCb = 2.0 - 2.0 * d3;
        this.GY = 1.0 / d2;
        this.GB = -d3 / d2;
        this.GR = -d / d2;
    }

    public double getLumaRed() {
        return this.LumaRed;
    }

    public double getLumaGreen() {
        return this.LumaGreen;
    }

    public double getLumaBlue() {
        return this.LumaBlue;
    }

    public void setRfBWY(double d, double d2) {
        this.RfBY = d;
        this.RfWY = d2;
    }

    public void setRfBWCb(double d, double d2) {
        this.RfBCb = d;
        this.RfWCb = d2;
    }

    public void setRfBWCr(double d, double d2) {
        this.RfBCr = d;
        this.RfWCr = d2;
    }

    public int read() throws IOException {
        throw new IOException(this.getClass().getName() + ".read:\t\nInternal Error: Please use read(int[] buf,int off,int len).");
    }

    protected int convert(int n) throws IOException {
        double d = n >> 16 & 0xFF;
        double d2 = n >> 8 & 0xFF;
        double d3 = n & 0xFF;
        d = (d - this.RfBY) * 255.0 / (this.RfWY - this.RfBY);
        d2 = (d2 - this.RfBCb) * 127.0 / (this.RfWCb - this.RfBCb);
        int n2 = (int)Math.round(d + this.RCr * (d3 = (d3 - this.RfBCr) * 127.0 / (this.RfWCr - this.RfBCr)));
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        int n3 = (int)Math.round(d + this.BCb * d2);
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        int n4 = (int)Math.round(d * this.GY + this.GB * (double)n3 + this.GR * (double)n2);
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > 255) {
            n4 = 255;
        }
        return n2 << 16 | n4 << 8 | n3;
    }

    public int read(int[] nArray, int n, int n2) throws IOException {
        n2 = ((IntFilterInputStream)this.in).read(nArray, n, n2);
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.convert(nArray[n + i]);
        }
        return n2;
    }
}

