/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TIFFSubSamplingOutputStream
extends FilterOutputStream {
    protected int w;
    protected int yf;
    protected int xf;
    protected byte[] red;
    protected byte[] green;
    protected byte[] blue;
    protected int y;
    protected int x;
    protected int col;
    protected boolean needToFlush;
    protected int ww;

    public TIFFSubSamplingOutputStream(OutputStream outputStream, int n, int n2, int n3) {
        super(outputStream);
        this.w = n;
        this.yf = n2;
        this.xf = n3;
        this.y = 0;
        this.x = 0;
        this.col = 0;
        this.needToFlush = false;
        this.ww = (n + n3 - 1) / n3 * n3;
        this.red = new byte[this.ww * n2];
        this.green = new byte[this.ww * n2];
        this.blue = new byte[this.ww * n2];
    }

    protected void writeDataUnits() throws IOException {
        for (int i = 0; i < this.ww; i += this.xf) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.ww * this.yf; n2 += this.ww) {
                for (n = 0; n < this.xf; ++n) {
                    this.out.write(this.red[n2 + i + n]);
                }
            }
            for (n2 = 0; n2 < this.ww * this.yf; n2 += this.ww) {
                for (n = 0; n < this.xf; ++n) {
                    this.out.write(this.green[n2 + i + n]);
                }
            }
            for (n2 = 0; n2 < this.ww * this.yf; n2 += this.ww) {
                for (n = 0; n < this.xf; ++n) {
                    this.out.write(this.blue[n2 + i + n]);
                }
            }
        }
        this.needToFlush = false;
    }

    public void write(int n) throws IOException {
        int n2 = this.y * this.ww + this.x;
        switch (this.col++) {
            case 0: {
                this.red[n2] = (byte)n;
                break;
            }
            case 1: {
                this.green[n2] = (byte)n;
                break;
            }
            case 2: {
                this.blue[n2] = (byte)n;
                ++this.x;
                this.col = 0;
            }
        }
        if (this.x == this.w) {
            ++this.y;
            this.x = 0;
        }
        if (this.y == this.yf) {
            this.y = 0;
            this.writeDataUnits();
        } else {
            this.needToFlush = true;
        }
    }

    public void flush() throws IOException {
        if (this.needToFlush) {
            this.writeDataUnits();
        }
        this.y = 0;
        this.x = 0;
        this.col = 0;
        super.flush();
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TIFFSubSamplingOutputStream tIFFSubSamplingOutputStream = new TIFFSubSamplingOutputStream(byteArrayOutputStream, 10, 4, 4);
            for (int i = 0; i < 2; ++i) {
                for (n = 0; n < 10; ++n) {
                    tIFFSubSamplingOutputStream.write((i << 6) + (n << 2));
                    tIFFSubSamplingOutputStream.write((i << 6) + (n << 2) + 1);
                    tIFFSubSamplingOutputStream.write((i << 6) + (n << 2) + 2);
                }
            }
            tIFFSubSamplingOutputStream.flush();
            tIFFSubSamplingOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (n = 0; n < byArray.length; ++n) {
                byte by = byArray[n];
                int n2 = by >> 6 & 3;
                int n3 = by >> 2 & 0xF;
                int n4 = by & 3;
                System.out.println("[" + n + "] => y=" + n2 + " x=" + n3 + " c=" + n4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

