/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.util.Locale;
import javax.imageio.ImageWriteParam;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;
import uk.co.mmscomputing.imageio.tiff.TIFFIIOParamController;

public class TIFFImageWriteParam
extends ImageWriteParam
implements TIFFConstants {
    private static String[] photometricinterpretations = new String[]{"WHITEISZERO", "BLACKISZERO", "RGB", "PaletteColor", "TransparencyMask", "CMYK", "YCbCr"};
    private static String[] compressiontypes = new String[]{"none", "mh", "t4mh", "t4mr", "t6mmr", "jpeg"};
    private int photometricinterpretation = 0;
    private float quality = 0.5f;
    private int subsampling = 34;
    private double xres = 72.0;
    private double yres = 72.0;

    public TIFFImageWriteParam(Locale locale) {
        super(locale);
        this.compressionTypes = compressiontypes;
        this.setCompressionMode(2);
        this.setCompressionType("t6mmr");
        this.setController(new TIFFIIOParamController(locale));
    }

    public boolean canWriteCompressed() {
        return true;
    }

    public void setPhotometricInterpretation(String string) {
        for (int i = 0; i < photometricinterpretations.length; ++i) {
            if (!string.equals(photometricinterpretations[i])) continue;
            this.photometricinterpretation = i;
            return;
        }
        throw new IllegalArgumentException(this.getClass().getName() + ".setPhotometricInterpretation\n\tUnknown Photometric Interpretation.");
    }

    public void setCompressionType(String string) {
        super.setCompressionType(string);
        if (string.equals("mh")) {
            this.photometricinterpretation = 0;
        } else if (string.equals("t4mh")) {
            this.photometricinterpretation = 0;
        } else if (string.equals("t4mr")) {
            this.photometricinterpretation = 0;
        } else if (string.equals("t6mmr")) {
            this.photometricinterpretation = 0;
        } else if (string.equals("jpeg")) {
            // empty if block
        }
    }

    public void setCompressionQuality(float f) {
        if (!(0.0f <= f) || !(f <= 1.0f)) {
            throw new IllegalArgumentException(this.getClass().getName() + ".setQuality\n\tInvalid Quality Value. Should be in range [0.0 .. 1.0].");
        }
        this.quality = f;
    }

    public float getCompressionQuality() {
        return this.quality;
    }

    public void setSubSampling(int n) {
        if (n != 17 && n != 34) {
            throw new IllegalArgumentException(this.getClass().getName() + ".setSubSampling\n\tInvalid Sub Sampling Mode [0x11,0x22].");
        }
        this.subsampling = n;
    }

    public int getPhotometricInterpretation() {
        return this.photometricinterpretation;
    }

    public int getSubSampling() {
        return this.subsampling;
    }

    public void setXYResolution(double d, double d2) {
        this.xres = d;
        this.yres = d2;
    }

    public double getXResolution() {
        return this.xres;
    }

    public double getYResolution() {
        return this.yres;
    }
}

