/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import uk.co.mmscomputing.imageio.tiff.IFD;
import uk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory;
import uk.co.mmscomputing.imageio.tiff.TIFFClassFFactory;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;

public class TIFFImageReader
extends ImageReader
implements TIFFConstants {
    private Vector ifds = null;

    protected TIFFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.readIFDs();
        this.checkIndex(n);
        return this.readImage((IFD)this.ifds.elementAt(n));
    }

    public int getHeight(int n) throws IOException {
        this.readIFDs();
        this.checkIndex(n);
        return ((IFD)this.ifds.elementAt(n)).getHeight();
    }

    public int getWidth(int n) throws IOException {
        this.readIFDs();
        this.checkIndex(n);
        return ((IFD)this.ifds.elementAt(n)).getWidth();
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.readIFDs();
        this.checkIndex(n);
        ImageTypeSpecifier imageTypeSpecifier = null;
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    public int getNumImages(boolean bl) throws IOException {
        this.readIFDs();
        return this.ifds.size();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.readIFDs();
        this.checkIndex(n);
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    private void checkIndex(int n) {
        if (n > this.ifds.size()) {
            throw new IndexOutOfBoundsException("\n" + this.getClass().getName() + ".checkIndex:\n    Bad index in image reader");
        }
    }

    private long readImageFileHeader(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readUnsignedShort();
        if (n == 19789) {
            imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else if (n == 18761) {
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            throw new IOException("\n" + this.getClass().getName() + ".readImageFileHeader\n\tInvalid tiff document : MM or II missing.");
        }
        int n2 = imageInputStream.readUnsignedShort();
        if (n2 != 42) {
            throw new IOException("\n" + this.getClass().getName() + ".readImageFileHeader\n\tInvalid tiff document : Unsupported Version: " + n2 + ".");
        }
        return imageInputStream.readUnsignedInt();
    }

    private void readIFDs() throws IOException {
        if (this.ifds == null) {
            this.ifds = new Vector();
            ImageInputStream imageInputStream = (ImageInputStream)this.getInput();
            long l = this.readImageFileHeader(imageInputStream);
            while (l != 0L) {
                IFD iFD = new IFD();
                l = iFD.read(imageInputStream, l);
                this.ifds.add(iFD);
            }
        }
    }

    private BufferedImage readImage(IFD iFD) throws IOException {
        int n = iFD.getCompression();
        if (n == 3 || n == 4) {
            return TIFFClassFFactory.readImage((ImageInputStream)this.getInput(), iFD);
        }
        if (n == 6) {
            System.out.println("9\b" + this.getClass().getName() + ".readImage:\n\tDo not support old style JPEG compression.");
            return null;
        }
        return TIFFBaselineFactory.readImage((ImageInputStream)this.getInput(), iFD);
    }
}

