/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;

public abstract class TIFFClassFOutputStream
extends FilterOutputStream
implements TIFFConstants {
    protected ByteArrayOutputStream buf = null;
    protected boolean lastByteWasZero;
    protected int width;
    protected int height;
    protected int offset;
    protected int xres;
    protected int yres;

    public TIFFClassFOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.writeHeader();
        this.xres = 204;
        this.yres = 196;
    }

    public void setXYResolution(int n, int n2) {
        this.xres = n;
        this.yres = n2;
    }

    public void write(int n) throws IOException {
        this.lastByteWasZero = n == 0;
        this.buf.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    protected void writeShort(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
    }

    protected void writeInt(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
        this.out.write(n >> 16 & 0xFF);
        this.out.write(n >> 24 & 0xFF);
    }

    protected void writeHeader() throws IOException {
        this.writeShort(18761);
        this.writeShort(42);
        this.offset = 8;
    }

    public void writePageHeader(int n) throws IOException {
        this.buf = new ByteArrayOutputStream();
        this.width = n;
        this.height = 0;
        this.lastByteWasZero = false;
    }

    public abstract void writePageEnd() throws IOException;

    public void writeDocumentEnd() throws IOException {
        this.writeInt(0);
    }
}

