/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.imageio.tiff.DEFactory;
import uk.co.mmscomputing.imageio.tiff.IFD;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;
import uk.co.mmscomputing.imageio.tiff.TIFFImageWriteParam;
import uk.co.mmscomputing.io.BitSwapInputStream;
import uk.co.mmscomputing.io.ModHuffmanInputStream;
import uk.co.mmscomputing.io.ModHuffmanOutputStream;
import uk.co.mmscomputing.io.ModModREADInputStream;
import uk.co.mmscomputing.io.ModModREADOutputStream;
import uk.co.mmscomputing.io.ModREADInputStream;
import uk.co.mmscomputing.io.ModREADOutputStream;
import uk.co.mmscomputing.io.RLEBit1OutputStream;
import uk.co.mmscomputing.io.RLEBitInputStream;

public class TIFFClassFFactory
implements TIFFConstants {
    static final String cn = "uk.co.mmscomputing.imageio.tiff.TIFFClassFFactory";

    public static IFD writeImage(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, int n, TIFFImageWriteParam tIFFImageWriteParam) throws IOException {
        try {
            ModHuffmanOutputStream modHuffmanOutputStream;
            ColorModel colorModel = bufferedImage.getColorModel();
            if (bufferedImage.getType() != 12 || colorModel.getPixelSize() != 1) {
                throw new IOException("uk.co.mmscomputing.imageio.tiff.TIFFClassFFactory.writeImage:\n\tPlease convert image to black and white picture [TYPE_BYTE_BINARY,1 bps]");
            }
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            IFD iFD = new IFD();
            iFD.add(new DEFactory.NewSubfileTypeDE(2));
            iFD.add(new DEFactory.ImageWidthDE(n2));
            iFD.add(new DEFactory.ImageLengthDE(n3));
            DEFactory.BitsPerSampleDE bitsPerSampleDE = new DEFactory.BitsPerSampleDE(1);
            bitsPerSampleDE.setBitsPerSample(0, 1L);
            iFD.add(bitsPerSampleDE);
            switch (n) {
                case 2: 
                case 3: {
                    iFD.add(new DEFactory.CompressionDE(3));
                    break;
                }
                case 4: {
                    iFD.add(new DEFactory.CompressionDE(4));
                }
            }
            iFD.add(new DEFactory.PhotometricInterpretationDE(0));
            iFD.add(new DEFactory.FillOrderDE(2));
            DEFactory.StripOffsetsDE stripOffsetsDE = new DEFactory.StripOffsetsDE(1);
            iFD.add(stripOffsetsDE);
            iFD.add(new DEFactory.OrientationDE(1));
            iFD.add(new DEFactory.SamplesPerPixelDE(1));
            iFD.add(new DEFactory.RowsPerStripDE(n3));
            DEFactory.StripByteCountsDE stripByteCountsDE = new DEFactory.StripByteCountsDE(1);
            iFD.add(stripByteCountsDE);
            if (tIFFImageWriteParam == null) {
                iFD.add(new DEFactory.XResolutionDE(204.0));
                iFD.add(new DEFactory.YResolutionDE(196.0));
            } else {
                iFD.add(new DEFactory.XResolutionDE(tIFFImageWriteParam.getXResolution()));
                iFD.add(new DEFactory.YResolutionDE(tIFFImageWriteParam.getYResolution()));
            }
            switch (n) {
                case 2: {
                    iFD.add(new DEFactory.T4OptionsDE(4));
                    break;
                }
                case 3: {
                    iFD.add(new DEFactory.T4OptionsDE(5));
                    break;
                }
                case 4: {
                    iFD.add(new DEFactory.T6OptionsDE(0));
                }
            }
            iFD.add(new DEFactory.ResolutionUnitDE(2));
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            switch (n) {
                case 2: {
                    modHuffmanOutputStream = new ModHuffmanOutputStream(byteArrayOutputStream);
                    break;
                }
                case 3: {
                    modHuffmanOutputStream = new ModREADOutputStream(byteArrayOutputStream, n2);
                    break;
                }
                case 4: {
                    modHuffmanOutputStream = new ModModREADOutputStream(byteArrayOutputStream, n2);
                    break;
                }
                default: {
                    throw new IOException("uk.co.mmscomputing.imageio.tiff.TIFFClassFFactory.writeImage: Internal Error: Unknown compression = " + n);
                }
            }
            TIFFClassFFactory.copyout(modHuffmanOutputStream, byArray, n2, n3);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            stripByteCountsDE.setCount(0, byArray2.length);
            stripOffsetsDE.setOffset(0, imageOutputStream.getStreamPosition());
            imageOutputStream.write(byArray2);
            return iFD;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("uk.co.mmscomputing.imageio.tiff.TIFFClassFFactory.writeImage:\n\t" + exception.getMessage());
        }
    }

    private static void copyout(ModHuffmanOutputStream modHuffmanOutputStream, byte[] byArray, int n, int n2) throws IOException {
        RLEBit1OutputStream rLEBit1OutputStream = new RLEBit1OutputStream(modHuffmanOutputStream);
        int n3 = n >> 3;
        int n4 = 8 - (n & 7);
        int n5 = 0;
        if (n4 == 8) {
            for (int i = 0; i < n2; ++i) {
                rLEBit1OutputStream.setStartCodeWord(1);
                modHuffmanOutputStream.writeEOL();
                rLEBit1OutputStream.write(byArray, n5, n3);
                rLEBit1OutputStream.flush();
                n5 += n3;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                rLEBit1OutputStream.setStartCodeWord(1);
                modHuffmanOutputStream.writeEOL();
                rLEBit1OutputStream.write(byArray, n5, n3);
                rLEBit1OutputStream.writeBits(byArray[n5 + n3], 7, n4);
                rLEBit1OutputStream.flush();
                n5 += n3 + 1;
            }
        }
        if (modHuffmanOutputStream instanceof ModModREADOutputStream) {
            ((ModModREADOutputStream)modHuffmanOutputStream).writeEOFB();
        }
        rLEBit1OutputStream.close();
    }

    public static BufferedImage readImage(ImageInputStream imageInputStream, IFD iFD) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            int n = iFD.getWidth();
            int n2 = iFD.getHeight();
            bufferedImage = new BufferedImage(n, n2, 12);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            long[] lArray = iFD.getStripOffsets();
            long[] lArray2 = iFD.getStripByteCounts();
            boolean bl = false;
            int n3 = 0;
            for (int i = 0; i < lArray.length; ++i) {
                imageInputStream.seek(lArray[i]);
                byte[] byArray2 = new byte[(int)lArray2[i]];
                imageInputStream.read(byArray2);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                ModHuffmanInputStream modHuffmanInputStream = iFD.getFillOrder() == 1 ? TIFFClassFFactory.getDecoder(new BitSwapInputStream(byteArrayInputStream), iFD) : TIFFClassFFactory.getDecoder(byteArrayInputStream, iFD);
                n3 = TIFFClassFFactory.copyin(byArray, n3, modHuffmanInputStream, n, iFD.getPhotometricInterpretation() != 0);
            }
            return bufferedImage;
        }
        catch (Exception exception) {
            System.out.println("uk.co.mmscomputing.imageio.tiff.TIFFClassFFactory.readImage:\n\t" + exception.getMessage());
            exception.printStackTrace();
            return bufferedImage;
        }
    }

    private static ModHuffmanInputStream getDecoder(InputStream inputStream, IFD iFD) throws IOException {
        switch (iFD.getCompression()) {
            case 3: {
                int n = iFD.getT4Options();
                if ((n & 1) == 0) {
                    return new ModHuffmanInputStream(inputStream);
                }
                return new ModREADInputStream(inputStream, iFD.getWidth());
            }
            case 4: {
                int n = iFD.getT6Options();
                return new ModModREADInputStream(inputStream, iFD.getWidth());
            }
        }
        throw new IOException("uk.co.mmscomputing.imageio.tiff.TIFFClassFFactory.getCoder: Internal Error: Unknown compression.");
    }

    private static int copyin(byte[] byArray, int n, ModHuffmanInputStream modHuffmanInputStream, int n2, boolean bl) throws IOException {
        block7: {
            RLEBitInputStream rLEBitInputStream = new RLEBitInputStream(modHuffmanInputStream);
            rLEBitInputStream.setInvert(bl);
            if ((n2 & 7) == 0) {
                byte[] byArray2 = new byte[n2 >> 3];
                int n3 = 0;
                while (true) {
                    rLEBitInputStream.resetToStartCodeWord();
                    modHuffmanInputStream.readEOL();
                    try {
                        n3 = rLEBitInputStream.read(byArray2);
                        if (n3 == -1) break block7;
                        System.arraycopy(byArray2, 0, byArray, n, n3);
                    }
                    catch (ModHuffmanInputStream.ModHuffmanCodingException modHuffmanCodingException) {
                        System.out.println("uk.co.mmscomputing.imageio.tiff.TIFFClassFFactory.copyin:\n\t" + modHuffmanCodingException);
                    }
                    n += n3;
                }
            }
            byte[] byArray3 = new byte[n2 + 7 >> 3];
            int n4 = 0;
            int n5 = 8 - (n2 & 7);
            while (true) {
                rLEBitInputStream.resetToStartCodeWord();
                modHuffmanInputStream.readEOL();
                try {
                    n4 = rLEBitInputStream.read(byArray3, 0, byArray3.length - 1);
                    if (n4 == -1) break;
                    int n6 = rLEBitInputStream.readBits(7, n5);
                    byArray3[n4] = (byte)n6;
                    System.arraycopy(byArray3, 0, byArray, n, n4 + 1);
                }
                catch (ModHuffmanInputStream.ModHuffmanCodingException modHuffmanCodingException) {
                    System.out.println("uk.co.mmscomputing.imageio.tiff.TIFFClassFFactory.copyin:\n\t" + modHuffmanCodingException);
                }
                n += n4 + 1;
            }
        }
        return n;
    }
}

