/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGInputStream;
import uk.co.mmscomputing.imageio.tiff.IFD;
import uk.co.mmscomputing.imageio.tiff.TIFFCMYKInputStream;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;
import uk.co.mmscomputing.imageio.tiff.TIFFSubSamplingInputStream;
import uk.co.mmscomputing.imageio.tiff.TIFFYCbCrInputStream;
import uk.co.mmscomputing.io.BitSwapInputStream;
import uk.co.mmscomputing.io.IntFilterInputStream;
import uk.co.mmscomputing.io.InvertedInputStream;
import uk.co.mmscomputing.io.LZWInputStream;
import uk.co.mmscomputing.io.ModHuffmanInputStream;
import uk.co.mmscomputing.io.PackBitsInputStream;
import uk.co.mmscomputing.io.RGBInputStream;
import uk.co.mmscomputing.io.RLEBitInputStream;

public class TIFFBaselineFactory
implements TIFFConstants {
    private static final String cn = "uk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory";
    private static final String email = "\nPlease send this tiff file to mm@mms-computing.co.uk.";
    private static final IndexColorModel bwwhiteiszero;
    private static final IndexColorModel bwblackiszero;
    private static final IndexColorModel graywhiteiszero;
    private static final IndexColorModel grayblackiszero;

    public static BufferedImage readImage(ImageInputStream imageInputStream, IFD iFD) throws IOException {
        int n = iFD.getPhotometricInterpretation();
        int n2 = iFD.getSamplesPerPixel();
        int n3 = iFD.getBitsPerSample(0);
        int n4 = iFD.getPlanarConfiguration();
        if (n4 != 1) {
            System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readImage:\n\tDo only support Planar Configuration 1.\nPlease send this tiff file to mm@mms-computing.co.uk.");
            return null;
        }
        if (iFD.getSampleFormat() != 1) {
            System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readImage:\n\tDo not support sample format other than unsigned integer.\nPlease send this tiff file to mm@mms-computing.co.uk.");
            return null;
        }
        switch (n) {
            case 0: {
                if (n2 != 1) break;
                switch (n3) {
                    case 1: {
                        return TIFFBaselineFactory.readBWImage(imageInputStream, iFD, bwwhiteiszero);
                    }
                    case 4: {
                        return TIFFBaselineFactory.read4bitImage(imageInputStream, iFD, graywhiteiszero);
                    }
                    case 8: {
                        return TIFFBaselineFactory.readGray8bitImage(imageInputStream, iFD, true);
                    }
                }
                break;
            }
            case 1: {
                if (n2 != 1) break;
                switch (n3) {
                    case 1: {
                        return TIFFBaselineFactory.readBWImage(imageInputStream, iFD, bwblackiszero);
                    }
                    case 4: {
                        return TIFFBaselineFactory.read4bitImage(imageInputStream, iFD, grayblackiszero);
                    }
                    case 8: {
                        return TIFFBaselineFactory.readGray8bitImage(imageInputStream, iFD, false);
                    }
                }
                break;
            }
            case 2: {
                if (n2 >= 3) {
                    for (int i = 0; i < n2; ++i) {
                        if (iFD.getBitsPerSample(i) == 8) continue;
                        System.out.println("uk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readImage:\n\tDo only support 8 bits samples.");
                        break;
                    }
                    return TIFFBaselineFactory.readRGBImage(imageInputStream, iFD, n2);
                }
                System.out.println("uk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readImage:\n\tInvalid tiff file, less than three samples per pixel in rgb file.");
                break;
            }
            case 3: {
                if (n2 != 1) break;
                switch (n3) {
                    case 4: {
                        return TIFFBaselineFactory.read4bitImage(imageInputStream, iFD, iFD.getColorModel());
                    }
                    case 8: {
                        return TIFFBaselineFactory.read8bitImage(imageInputStream, iFD);
                    }
                }
                break;
            }
            case 4: {
                if (n2 != 1 || iFD.getBitsPerSample(0) == 1) break;
                System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readImage:\n\tDo not support transparency mask.\nPlease send this tiff file to mm@mms-computing.co.uk.");
                break;
            }
            case 5: {
                if (n2 == 4) {
                    for (int i = 0; i < n2; ++i) {
                        if (iFD.getBitsPerSample(i) == 8) continue;
                        System.out.println("uk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readImage:\n\tUnsupported tiff file. Support only 8 bit samples in CMYK file.");
                        break;
                    }
                    return TIFFBaselineFactory.readCMYKImage(imageInputStream, iFD);
                }
                System.out.println("uk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readImage:\n\tUnsupported tiff file, Support only four samples per pixel CMYK.");
                break;
            }
            case 6: {
                if (n2 == 3) {
                    for (int i = 0; i < n2; ++i) {
                        if (iFD.getBitsPerSample(i) == 8) continue;
                        System.out.println("uk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readImage:\n\tInvalid tiff file. TIFF does only support 8 bit samples in YCbCr file.");
                        break;
                    }
                    return TIFFBaselineFactory.readYCbCrImage(imageInputStream, iFD);
                }
                System.out.println("uk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readImage:\n\tInvalid tiff file, a TIFF YCbCr file needs to have three samples per pixel.");
                break;
            }
        }
        System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readImage:\n\tNot a Baseline TIFF File. Invalid or unsupported parameters.\nPlease send this tiff file to mm@mms-computing.co.uk.");
        return null;
    }

    private static BufferedImage readBWImage(ImageInputStream imageInputStream, IFD iFD, IndexColorModel indexColorModel) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            int n = iFD.getWidth();
            int n2 = iFD.getHeight();
            int n3 = iFD.getCompression();
            bufferedImage = new BufferedImage(n, n2, 12, indexColorModel);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            long[] lArray = iFD.getStripOffsets();
            long[] lArray2 = iFD.getStripByteCounts();
            int n4 = iFD.getRowsPerStrip();
            int n5 = iFD.getPredictor();
            int n6 = 0;
            int n7 = (n + 7 >> 3) * n4;
            int n8 = (n + 7 >> 3) * n2;
            for (int i = 0; i < lArray.length; ++i) {
                imageInputStream.seek(lArray[i]);
                byte[] byArray2 = new byte[(int)lArray2[i]];
                imageInputStream.read(byArray2);
                InputStream inputStream = new ByteArrayInputStream(byArray2);
                if (n3 == 2) {
                    if (iFD.getFillOrder() == 1) {
                        inputStream = new BitSwapInputStream(inputStream);
                    }
                    n6 = TIFFBaselineFactory.readMH(byArray, n6, inputStream, n);
                    continue;
                }
                if (iFD.getFillOrder() != 1) {
                    inputStream = new BitSwapInputStream(inputStream);
                }
                switch (n3) {
                    case 1: {
                        break;
                    }
                    case 5: {
                        inputStream = new LZWInputStream(inputStream, 8, false);
                        break;
                    }
                    case 32773: {
                        inputStream = new PackBitsInputStream(inputStream);
                        break;
                    }
                    default: {
                        System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readBWImage:\n\tDo not support compression scheme " + n3 + ".");
                        return bufferedImage;
                    }
                }
                n7 = n8 - n6 < n7 ? n8 - n6 : n7;
                n6 += inputStream.read(byArray, n6, n7);
            }
        }
        catch (Exception exception) {
            System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readImage:\n\t" + exception.getMessage());
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    private static int readMH(byte[] byArray, int n, InputStream inputStream, int n2) throws IOException {
        block7: {
            ModHuffmanInputStream modHuffmanInputStream = new ModHuffmanInputStream(inputStream);
            RLEBitInputStream rLEBitInputStream = new RLEBitInputStream(modHuffmanInputStream);
            if ((n2 & 7) == 0) {
                byte[] byArray2 = new byte[n2 >> 3];
                int n3 = 0;
                while (true) {
                    rLEBitInputStream.resetToStartCodeWord();
                    try {
                        n3 = rLEBitInputStream.read(byArray2);
                        if (n3 == -1) break block7;
                        System.arraycopy(byArray2, 0, byArray, n, n3);
                        modHuffmanInputStream.skipPadding(8);
                    }
                    catch (ModHuffmanInputStream.ModHuffmanCodingException modHuffmanCodingException) {
                        System.out.println("uk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.copyin:\n\t" + modHuffmanCodingException);
                    }
                    n += n3;
                }
            }
            byte[] byArray3 = new byte[n2 + 7 >> 3];
            int n4 = 0;
            int n5 = 8 - (n2 & 7);
            while (true) {
                rLEBitInputStream.resetToStartCodeWord();
                try {
                    n4 = rLEBitInputStream.read(byArray3, 0, byArray3.length - 1);
                    if (n4 == -1) break;
                    int n6 = rLEBitInputStream.readBits(7, n5);
                    byArray3[n4] = (byte)n6;
                    System.arraycopy(byArray3, 0, byArray, n, n4 + 1);
                    modHuffmanInputStream.skipPadding(8);
                }
                catch (ModHuffmanInputStream.ModHuffmanCodingException modHuffmanCodingException) {
                    System.out.println("uk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.copyin:\n\t" + modHuffmanCodingException);
                }
                n += n4 + 1;
            }
        }
        return n;
    }

    private static BufferedImage read4bitImage(ImageInputStream imageInputStream, IFD iFD, IndexColorModel indexColorModel) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            int n = iFD.getWidth();
            int n2 = iFD.getHeight();
            int n3 = iFD.getCompression();
            bufferedImage = new BufferedImage(n, n2, 12, indexColorModel);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            long[] lArray = iFD.getStripOffsets();
            long[] lArray2 = iFD.getStripByteCounts();
            int n4 = iFD.getRowsPerStrip();
            int n5 = iFD.getPredictor();
            if (n5 != 1) {
                System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.read4bitImage:\n\tDo not support 'Differencing Predictor' yet.");
                return bufferedImage;
            }
            int n6 = 0;
            int n7 = (n + 1 >> 1) * n4;
            int n8 = (n + 1 >> 1) * n2;
            for (int i = 0; i < lArray.length; ++i) {
                imageInputStream.seek(lArray[i]);
                byte[] byArray2 = new byte[(int)lArray2[i]];
                imageInputStream.read(byArray2);
                InputStream inputStream = new ByteArrayInputStream(byArray2);
                if (iFD.getFillOrder() != 1) {
                    inputStream = new BitSwapInputStream(inputStream);
                }
                switch (n3) {
                    case 1: {
                        break;
                    }
                    case 5: {
                        inputStream = new LZWInputStream(inputStream, 8, false);
                        break;
                    }
                    case 32773: {
                        inputStream = new PackBitsInputStream(inputStream);
                        break;
                    }
                    default: {
                        System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.read4bitImage:\n\tDo not support compression scheme " + n3 + ".");
                        return bufferedImage;
                    }
                }
                n7 = n8 - n6 < n7 ? n8 - n6 : n7;
                n6 += inputStream.read(byArray, n6, n7);
            }
        }
        catch (Exception exception) {
            System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.read4bitImage:\n\t" + exception.getMessage());
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    private static BufferedImage readGray8bitImage(ImageInputStream imageInputStream, IFD iFD, boolean bl) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            JPEGInputStream jPEGInputStream;
            int n = iFD.getWidth();
            int n2 = iFD.getHeight();
            int n3 = iFD.getCompression();
            bufferedImage = new BufferedImage(n, n2, 10);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            long[] lArray = iFD.getStripOffsets();
            long[] lArray2 = iFD.getStripByteCounts();
            int n4 = iFD.getRowsPerStrip();
            int n5 = iFD.getPredictor();
            if (n5 != 1) {
                System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readGray8bitImage:\n\tDo not support 'Differencing Predictor' yet.");
                return bufferedImage;
            }
            try {
                jPEGInputStream = new JPEGInputStream(new ByteArrayInputStream(iFD.getJPEGTables()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                jPEGInputStream = null;
            }
            int n6 = 0;
            int n7 = n * n4;
            int n8 = n * n2;
            for (int i = 0; i < lArray.length; ++i) {
                imageInputStream.seek(lArray[i]);
                byte[] byArray2 = new byte[(int)lArray2[i]];
                imageInputStream.read(byArray2);
                InputStream inputStream = new ByteArrayInputStream(byArray2);
                if (iFD.getFillOrder() != 1) {
                    inputStream = new BitSwapInputStream(inputStream);
                }
                switch (n3) {
                    case 1: {
                        break;
                    }
                    case 5: {
                        inputStream = new LZWInputStream(inputStream, 8, false);
                        break;
                    }
                    case 7: {
                        if (jPEGInputStream != null) {
                            inputStream = new JPEGInputStream(inputStream, jPEGInputStream.getQTs(), jPEGInputStream.getDCIns(), jPEGInputStream.getACIns());
                            break;
                        }
                        inputStream = new JPEGInputStream(inputStream);
                        break;
                    }
                    case 32773: {
                        inputStream = new PackBitsInputStream(inputStream);
                        break;
                    }
                    default: {
                        System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readGray8bitImage:\n\tDo not support compression scheme " + n3 + ".");
                        return bufferedImage;
                    }
                }
                if (bl) {
                    inputStream = new InvertedInputStream(inputStream);
                }
                n7 = n8 - n6 < n7 ? n8 - n6 : n7;
                n6 += ((InputStream)inputStream).read(byArray, n6, n7);
            }
        }
        catch (Exception exception) {
            System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readGray8bitImage:\n\t" + exception.getMessage());
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    private static BufferedImage read8bitImage(ImageInputStream imageInputStream, IFD iFD) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            int n = iFD.getWidth();
            int n2 = iFD.getHeight();
            int n3 = iFD.getCompression();
            IndexColorModel indexColorModel = iFD.getColorModel();
            bufferedImage = new BufferedImage(n, n2, 13, indexColorModel);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            long[] lArray = iFD.getStripOffsets();
            long[] lArray2 = iFD.getStripByteCounts();
            int n4 = iFD.getRowsPerStrip();
            int n5 = iFD.getPredictor();
            if (n5 != 1) {
                System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.read8bitImage:\n\tDo not support 'Differencing Predictor' yet.\nPlease send this tiff file to mm@mms-computing.co.uk.");
                return bufferedImage;
            }
            int n6 = 0;
            int n7 = n * n4;
            int n8 = n * n2;
            for (int i = 0; i < lArray.length; ++i) {
                imageInputStream.seek(lArray[i]);
                byte[] byArray2 = new byte[(int)lArray2[i]];
                imageInputStream.read(byArray2);
                InputStream inputStream = new ByteArrayInputStream(byArray2);
                if (iFD.getFillOrder() != 1) {
                    inputStream = new BitSwapInputStream(inputStream);
                }
                switch (n3) {
                    case 1: {
                        break;
                    }
                    case 5: {
                        inputStream = new LZWInputStream(inputStream, 8, false);
                        break;
                    }
                    case 32773: {
                        inputStream = new PackBitsInputStream(inputStream);
                        break;
                    }
                    default: {
                        System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.read8bitImage:\n\tDo not support compression scheme " + n3 + ".");
                        return bufferedImage;
                    }
                }
                n7 = n8 - n6 < n7 ? n8 - n6 : n7;
                n6 += inputStream.read(byArray, n6, n7);
            }
        }
        catch (Exception exception) {
            System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.read8bitImage:\n\t" + exception.getMessage());
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    private static BufferedImage readRGBImage(ImageInputStream imageInputStream, IFD iFD, int n) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            JPEGInputStream jPEGInputStream;
            int n2 = iFD.getWidth();
            int n3 = iFD.getHeight();
            int n4 = iFD.getCompression();
            int n5 = 0;
            int n6 = iFD.getExtraSamplesLength();
            if (n6 > 0) {
                if (n - 3 == n6) {
                    n5 = iFD.getExtraSample(n6 - 1);
                } else {
                    System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readRGBImage:\n\tInvalid TIFF file. 'Samples per Pixel' != ('Extra Samples' + 3).");
                }
            }
            switch (n5) {
                case 1: {
                    bufferedImage = new BufferedImage(n2, n3, 3);
                }
                case 2: {
                    bufferedImage = new BufferedImage(n2, n3, 2);
                }
            }
            bufferedImage = new BufferedImage(n2, n3, 1);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            long[] lArray = iFD.getStripOffsets();
            long[] lArray2 = iFD.getStripByteCounts();
            int n7 = iFD.getRowsPerStrip();
            int n8 = iFD.getPredictor();
            if (n8 != 1) {
                System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readRGBImage:\n\tDo not support 'Differencing Predictor' yet.\nPlease send this tiff file to mm@mms-computing.co.uk.");
                return bufferedImage;
            }
            try {
                jPEGInputStream = new JPEGInputStream(new ByteArrayInputStream(iFD.getJPEGTables()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                jPEGInputStream = null;
            }
            int n9 = 0;
            int n10 = n2 * n7;
            int n11 = n2 * n3;
            for (int i = 0; i < lArray.length; ++i) {
                IntFilterInputStream intFilterInputStream;
                imageInputStream.seek(lArray[i]);
                byte[] byArray = new byte[(int)lArray2[i]];
                imageInputStream.read(byArray);
                InputStream inputStream = new ByteArrayInputStream(byArray);
                if (iFD.getFillOrder() != 1) {
                    inputStream = new BitSwapInputStream(inputStream);
                }
                n10 = n11 - n9 < n10 ? n11 - n9 : n10;
                switch (n4) {
                    case 1: {
                        intFilterInputStream = new RGBInputStream(inputStream, n, n5 != 0);
                        break;
                    }
                    case 5: {
                        inputStream = new LZWInputStream(inputStream, 8, false);
                        intFilterInputStream = new RGBInputStream(inputStream, n, n5 != 0);
                        break;
                    }
                    case 7: {
                        if (jPEGInputStream != null) {
                            intFilterInputStream = new JPEGInputStream(inputStream, jPEGInputStream.getQTs(), jPEGInputStream.getDCIns(), jPEGInputStream.getACIns());
                            break;
                        }
                        intFilterInputStream = new JPEGInputStream(inputStream);
                        break;
                    }
                    case 32773: {
                        inputStream = new PackBitsInputStream(inputStream);
                        intFilterInputStream = new RGBInputStream(inputStream, n, n5 != 0);
                        break;
                    }
                    default: {
                        System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readRGBImage:\n\tDo not support compression scheme " + n4 + ".");
                        return bufferedImage;
                    }
                }
                n9 += intFilterInputStream.read(nArray, n9, n10);
            }
        }
        catch (Exception exception) {
            System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readRGBImage:\n\t" + exception.getMessage());
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    private static BufferedImage readCMYKImage(ImageInputStream imageInputStream, IFD iFD) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            int n = iFD.getWidth();
            int n2 = iFD.getHeight();
            int n3 = iFD.getCompression();
            bufferedImage = new BufferedImage(n, n2, 1);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            long[] lArray = iFD.getStripOffsets();
            long[] lArray2 = iFD.getStripByteCounts();
            int n4 = iFD.getRowsPerStrip();
            int n5 = 0;
            int n6 = n * n4;
            int n7 = n * n2;
            for (int i = 0; i < lArray.length; ++i) {
                imageInputStream.seek(lArray[i]);
                byte[] byArray = new byte[(int)lArray2[i]];
                imageInputStream.read(byArray);
                InputStream inputStream = new ByteArrayInputStream(byArray);
                if (iFD.getFillOrder() != 1) {
                    inputStream = new BitSwapInputStream(inputStream);
                }
                switch (n3) {
                    case 1: {
                        break;
                    }
                    case 5: {
                        inputStream = new LZWInputStream(inputStream, 8, false);
                        break;
                    }
                    case 32773: {
                        inputStream = new PackBitsInputStream(inputStream);
                        break;
                    }
                    default: {
                        System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readCMYKImage:\n\tDo not support compression scheme " + n3 + ".");
                        return bufferedImage;
                    }
                }
                n6 = n7 - n5 < n6 ? n7 - n5 : n6;
                TIFFCMYKInputStream tIFFCMYKInputStream = new TIFFCMYKInputStream(inputStream);
                n5 += tIFFCMYKInputStream.read(nArray, n5, n6);
            }
        }
        catch (Exception exception) {
            System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readCMYKImage:\n\t" + exception.getMessage());
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    private static BufferedImage readYCbCrImage(ImageInputStream imageInputStream, IFD iFD) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            JPEGInputStream jPEGInputStream;
            int n = iFD.getWidth();
            int n2 = iFD.getHeight();
            int n3 = iFD.getCompression();
            bufferedImage = new BufferedImage(n, n2, 1);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            long[] lArray = iFD.getStripOffsets();
            long[] lArray2 = iFD.getStripByteCounts();
            int n4 = iFD.getRowsPerStrip();
            int n5 = iFD.getPredictor();
            if (n5 != 1) {
                System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readYCbCrImage:\n\tDo not support 'Differencing Predictor' yet.\nPlease send this tiff file to mm@mms-computing.co.uk.");
                return bufferedImage;
            }
            try {
                jPEGInputStream = new JPEGInputStream(new ByteArrayInputStream(iFD.getJPEGTables()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                jPEGInputStream = null;
            }
            double[] dArray = iFD.getYCbCrCoefficients();
            long[] lArray3 = iFD.getYCbCrSubSampling();
            int n6 = iFD.getYCbCrPositioning();
            double[] dArray2 = iFD.getReferenceBlackWhite();
            int n7 = 0;
            int n8 = n * n4;
            int n9 = n * n2;
            for (int i = 0; i < lArray.length; ++i) {
                IntFilterInputStream intFilterInputStream;
                imageInputStream.seek(lArray[i]);
                byte[] byArray = new byte[(int)lArray2[i]];
                imageInputStream.read(byArray);
                InputStream inputStream = new ByteArrayInputStream(byArray);
                if (iFD.getFillOrder() != 1) {
                    inputStream = new BitSwapInputStream(inputStream);
                }
                switch (n3) {
                    case 1: {
                        intFilterInputStream = new TIFFSubSamplingInputStream(inputStream, n, (int)lArray3[1], (int)lArray3[0], n6);
                        break;
                    }
                    case 5: {
                        inputStream = new LZWInputStream(inputStream, 8, false);
                        intFilterInputStream = new TIFFSubSamplingInputStream(inputStream, n, (int)lArray3[1], (int)lArray3[0], n6);
                        break;
                    }
                    case 7: {
                        if (jPEGInputStream != null) {
                            intFilterInputStream = new JPEGInputStream(inputStream, jPEGInputStream.getQTs(), jPEGInputStream.getDCIns(), jPEGInputStream.getACIns());
                            break;
                        }
                        intFilterInputStream = new JPEGInputStream(inputStream);
                        break;
                    }
                    case 32773: {
                        inputStream = new PackBitsInputStream(inputStream);
                        intFilterInputStream = new TIFFSubSamplingInputStream(inputStream, n, (int)lArray3[1], (int)lArray3[0], n6);
                        break;
                    }
                    default: {
                        System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readYCbCrImage:\n\tDo not support compression scheme " + n3 + ".");
                        return bufferedImage;
                    }
                }
                n8 = n9 - n7 < n8 ? n9 - n7 : n8;
                TIFFYCbCrInputStream tIFFYCbCrInputStream = new TIFFYCbCrInputStream(intFilterInputStream);
                tIFFYCbCrInputStream.setColourCoefficients(dArray[0], dArray[1], dArray[2]);
                tIFFYCbCrInputStream.setRfBWY(dArray2[0], dArray2[1]);
                tIFFYCbCrInputStream.setRfBWCb(dArray2[2], dArray2[3]);
                tIFFYCbCrInputStream.setRfBWCr(dArray2[4], dArray2[5]);
                n7 += tIFFYCbCrInputStream.read(nArray, n7, n8);
            }
        }
        catch (Exception exception) {
            System.out.println("9\buk.co.mmscomputing.imageio.tiff.TIFFBaselineFactory.readYCbCrImage:\n\t" + exception.getMessage());
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    public static void main(String[] stringArray) {
        try {
            byte by;
            int n;
            for (n = 0; n < 256; n += 17) {
                by = (byte)n;
                System.out.print("" + by + ",");
            }
            System.out.println(" ");
            for (n = 255; n >= 0; n -= 17) {
                by = (byte)n;
                System.out.print("" + by + ",");
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    static {
        byte[] byArray = new byte[]{-1, 0};
        byte[] byArray2 = new byte[]{0, -1};
        bwwhiteiszero = new IndexColorModel(1, 2, byArray, byArray, byArray);
        bwblackiszero = new IndexColorModel(1, 2, byArray2, byArray2, byArray2);
        byte[] byArray3 = new byte[]{-1, -18, -35, -52, -69, -86, -103, -120, 119, 102, 85, 68, 51, 34, 17, 0};
        byte[] byArray4 = new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1};
        graywhiteiszero = new IndexColorModel(4, 16, byArray3, byArray3, byArray3);
        grayblackiszero = new IndexColorModel(4, 16, byArray4, byArray4, byArray4);
    }
}

