/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.awt.image.IndexColorModel;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.imageio.tiff.DE;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;

class DEFactory
implements TIFFConstants {
    DEFactory() {
    }

    public static DE read(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readUnsignedShort();
        switch (n) {
            case 254: {
                return new NewSubfileTypeDE(imageInputStream);
            }
            case 256: {
                return new ImageWidthDE(imageInputStream);
            }
            case 257: {
                return new ImageLengthDE(imageInputStream);
            }
            case 258: {
                return new BitsPerSampleDE(imageInputStream);
            }
            case 259: {
                return new CompressionDE(imageInputStream);
            }
            case 262: {
                return new PhotometricInterpretationDE(imageInputStream);
            }
            case 266: {
                return new FillOrderDE(imageInputStream);
            }
            case 269: {
                return new DocumentNameDE(imageInputStream);
            }
            case 270: {
                return new ImageDescriptionDE(imageInputStream);
            }
            case 273: {
                return new StripOffsetsDE(imageInputStream);
            }
            case 274: {
                return new OrientationDE(imageInputStream);
            }
            case 277: {
                return new SamplesPerPixelDE(imageInputStream);
            }
            case 278: {
                return new RowsPerStripDE(imageInputStream);
            }
            case 279: {
                return new StripByteCountsDE(imageInputStream);
            }
            case 282: {
                return new XResolutionDE(imageInputStream);
            }
            case 283: {
                return new YResolutionDE(imageInputStream);
            }
            case 284: {
                return new PlanarConfigurationDE(imageInputStream);
            }
            case 292: {
                return new T4OptionsDE(imageInputStream);
            }
            case 293: {
                return new T6OptionsDE(imageInputStream);
            }
            case 296: {
                return new ResolutionUnitDE(imageInputStream);
            }
            case 297: {
                return new PageNumberDE(imageInputStream);
            }
            case 305: {
                return new SoftwareDE(imageInputStream);
            }
            case 306: {
                return new DateTimeDE(imageInputStream);
            }
            case 315: {
                return new ArtistDE(imageInputStream);
            }
            case 317: {
                return new PredictorDE(imageInputStream);
            }
            case 320: {
                return new ColorMapDE(imageInputStream);
            }
            case 338: {
                return new ExtraSamplesDE(imageInputStream);
            }
            case 339: {
                return new SampleFormatDE(imageInputStream);
            }
            case 347: {
                return new JPEGTablesDE(imageInputStream);
            }
            case 529: {
                return new YCbCrCoefficientsDE(imageInputStream);
            }
            case 530: {
                return new YCbCrSubSamplingDE(imageInputStream);
            }
            case 531: {
                return new YCbCrPositioningDE(imageInputStream);
            }
            case 532: {
                return new ReferenceBlackWhiteDE(imageInputStream);
            }
        }
        return new UnknownDE(n, imageInputStream);
    }

    public static class ReferenceBlackWhiteDE
    extends DE {
        double[] reference;

        public ReferenceBlackWhiteDE(ImageInputStream imageInputStream) throws IOException {
            super(532);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.reference = this.readRealArray(imageInputStream);
        }

        public double getReference(int n) {
            return (int)this.reference[n];
        }

        public double[] getReference() {
            return this.reference;
        }

        public ReferenceBlackWhiteDE() throws IOException {
            super(532);
            this.reference = new double[6];
            this.setType(5);
            this.setCount(6L);
        }

        public void setY(double d, double d2) {
            this.reference[0] = d;
            this.reference[1] = d2;
        }

        public void setCb(double d, double d2) {
            this.reference[2] = d;
            this.reference[3] = d2;
        }

        public void setCr(double d, double d2) {
            this.reference[4] = d;
            this.reference[5] = d2;
        }

        public void write(ImageOutputStream imageOutputStream) throws IOException {
            this.writeRealArray(imageOutputStream, this.reference);
        }
    }

    public static class YCbCrPositioningDE
    extends DE {
        public YCbCrPositioningDE(ImageInputStream imageInputStream) throws IOException {
            super(531);
            this.read(imageInputStream);
        }
    }

    public static class YCbCrSubSamplingDE
    extends DE {
        long[] subSampling;

        public YCbCrSubSamplingDE(ImageInputStream imageInputStream) throws IOException {
            super(530);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.subSampling = this.readIntArray(imageInputStream);
        }

        public int getSubSampling(int n) {
            return (int)this.subSampling[n];
        }

        public long[] getSubSampling() {
            return this.subSampling;
        }

        public YCbCrSubSamplingDE() throws IOException {
            super(530);
            this.subSampling = new long[2];
            this.setType(3);
            this.setCount(2L);
        }

        public void setHoriz(int n) {
            this.subSampling[0] = n;
        }

        public void setVert(int n) {
            this.subSampling[1] = n;
        }

        public void write(ImageOutputStream imageOutputStream) throws IOException {
            this.writeIntArray(imageOutputStream, this.subSampling);
        }
    }

    public static class YCbCrCoefficientsDE
    extends DE {
        double[] coefficients = null;

        public YCbCrCoefficientsDE(ImageInputStream imageInputStream) throws IOException {
            super(529);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.coefficients = this.readRealArray(imageInputStream);
        }

        public double[] getCoefficients() {
            return this.coefficients;
        }

        public YCbCrCoefficientsDE() throws IOException {
            super(529);
            this.coefficients = new double[3];
            this.setType(5);
            this.setCount(3L);
        }

        public void setLumaRed(double d) {
            this.coefficients[0] = d;
        }

        public void setLumaGreen(double d) {
            this.coefficients[1] = d;
        }

        public void setLumaBlue(double d) {
            this.coefficients[2] = d;
        }

        public void write(ImageOutputStream imageOutputStream) throws IOException {
            this.writeRealArray(imageOutputStream, this.coefficients);
        }
    }

    public static class JPEGTablesDE
    extends DE {
        private byte[] jpegsegment;

        public JPEGTablesDE(ImageInputStream imageInputStream) throws IOException {
            super(347);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.jpegsegment = this.readByteArray(imageInputStream);
        }

        public byte[] getData() {
            return this.jpegsegment;
        }

        public JPEGTablesDE(byte[] byArray) throws IOException {
            super(347);
            this.setType(7);
            this.setCount(byArray.length);
            this.jpegsegment = byArray;
        }

        public void write(ImageOutputStream imageOutputStream) throws IOException {
            this.writeByteArray(imageOutputStream, this.jpegsegment);
        }
    }

    public static class SampleFormatDE
    extends DE {
        public SampleFormatDE(ImageInputStream imageInputStream) throws IOException {
            super(339);
            this.read(imageInputStream);
        }

        public SampleFormatDE(int n) throws IOException {
            super(339);
            this.setType(3);
            this.setCount(1L);
            this.setValue(n);
        }

        static int getDefault() {
            return 1;
        }
    }

    public static class ExtraSamplesDE
    extends DE {
        long[] exs;

        public ExtraSamplesDE(ImageInputStream imageInputStream) throws IOException {
            super(338);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.exs = this.readIntArray(imageInputStream);
        }

        public int getExtraSample(int n) {
            return (int)this.exs[n];
        }

        public long[] getExtraSamples() {
            return this.exs;
        }

        public ExtraSamplesDE(int n) throws IOException {
            super(338);
            this.exs = new long[n];
            this.setType(3);
            this.setCount(n);
        }

        public void setExtraSample(int n, long l) {
            this.exs[n] = l;
        }

        public void write(ImageOutputStream imageOutputStream) throws IOException {
            this.writeIntArray(imageOutputStream, this.exs);
        }
    }

    public static class ColorMapDE
    extends DE {
        private IndexColorModel cm = null;

        public ColorMapDE(ImageInputStream imageInputStream) throws IOException {
            super(320);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            int n;
            super.read(imageInputStream);
            long[] lArray = this.readIntArray(imageInputStream);
            int n2 = lArray.length / 3;
            byte[] byArray = new byte[n2];
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = new byte[n2];
            for (n = 0; n < n2; ++n) {
                byArray[n] = (byte)(lArray[n] & 0xFFL);
                byArray2[n] = (byte)(lArray[n2 + n] & 0xFFL);
                byArray3[n] = (byte)(lArray[n2 + n2 + n] & 0xFFL);
            }
            n = 0;
            for (int i = n2; i > 1; i >>>= 1) {
                ++n;
            }
            this.cm = new IndexColorModel(n, n2, byArray, byArray2, byArray3);
        }

        public IndexColorModel getColorModel() {
            return this.cm;
        }
    }

    public static class PredictorDE
    extends DE {
        public PredictorDE(ImageInputStream imageInputStream) throws IOException {
            super(317);
            this.read(imageInputStream);
        }

        public PredictorDE(int n) throws IOException {
            super(317);
            this.setType(3);
            this.setCount(1L);
            this.setValue(n);
        }

        static int getDefault() {
            return 1;
        }
    }

    public static class ArtistDE
    extends DE {
        String name;

        public ArtistDE(ImageInputStream imageInputStream) throws IOException {
            super(315);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.name = this.readString(imageInputStream)[0];
        }
    }

    public static class DateTimeDE
    extends DE {
        String datetime;

        public DateTimeDE(ImageInputStream imageInputStream) throws IOException {
            super(306);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.datetime = this.readString(imageInputStream)[0];
        }
    }

    public static class SoftwareDE
    extends DE {
        String name;

        public SoftwareDE(ImageInputStream imageInputStream) throws IOException {
            super(305);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.name = this.readString(imageInputStream)[0];
        }
    }

    public static class PageNumberDE
    extends DE {
        private long[] values;

        public PageNumberDE(ImageInputStream imageInputStream) throws IOException {
            super(297);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.values = this.readIntArray(imageInputStream);
        }

        public PageNumberDE(int n, int n2) throws IOException {
            super(297);
            this.values = new long[2];
            this.setType(3);
            this.setCount(2L);
        }

        public void setPage(int n) {
            this.values[0] = n;
        }

        public int getPage() {
            return (int)this.values[0];
        }

        public void setPageCount(int n) {
            this.values[1] = n;
        }

        public int getPageCount() {
            return (int)this.values[1];
        }

        public void write(ImageOutputStream imageOutputStream) throws IOException {
            this.writeIntArray(imageOutputStream, this.values);
        }
    }

    public static class ResolutionUnitDE
    extends DE {
        public ResolutionUnitDE(ImageInputStream imageInputStream) throws IOException {
            super(296);
            this.read(imageInputStream);
        }

        public ResolutionUnitDE(int n) throws IOException {
            super(296);
            this.setType(3);
            this.setCount(1L);
            this.setValue(n);
        }
    }

    public static class T6OptionsDE
    extends DE {
        public T6OptionsDE(ImageInputStream imageInputStream) throws IOException {
            super(293);
            this.read(imageInputStream);
        }

        public T6OptionsDE(int n) throws IOException {
            super(293);
            this.setType(4);
            this.setCount(1L);
            this.setValue(n);
        }

        public boolean is2Dimensional() {
            return (this.val & 1L) == 0L;
        }

        public boolean isCompressed() {
            return (this.val & 2L) == 0L;
        }
    }

    public static class T4OptionsDE
    extends DE {
        public T4OptionsDE(ImageInputStream imageInputStream) throws IOException {
            super(292);
            this.read(imageInputStream);
        }

        public T4OptionsDE(int n) throws IOException {
            super(292);
            this.setType(4);
            this.setCount(1L);
            this.setValue(n);
        }

        public boolean is1Dimensional() {
            return (this.val & 1L) == 0L;
        }

        public boolean is2Dimensional() {
            return (this.val & 1L) != 0L;
        }

        public boolean isCompressed() {
            return (this.val & 2L) == 0L;
        }

        public boolean isByteAligned() {
            return (this.val & 4L) != 0L;
        }
    }

    public static class PlanarConfigurationDE
    extends DE {
        public PlanarConfigurationDE(ImageInputStream imageInputStream) throws IOException {
            super(284);
            this.read(imageInputStream);
        }
    }

    public static class YResolutionDE
    extends DE {
        double yres;

        public YResolutionDE(ImageInputStream imageInputStream) throws IOException {
            super(283);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.yres = this.readReal(imageInputStream);
        }

        public YResolutionDE(double d) throws IOException {
            super(283);
            this.setType(5);
            this.setCount(1L);
            this.yres = d;
        }

        public void write(ImageOutputStream imageOutputStream) throws IOException {
            this.writeReal(imageOutputStream, this.yres);
        }
    }

    public static class XResolutionDE
    extends DE {
        double xres;

        public XResolutionDE(ImageInputStream imageInputStream) throws IOException {
            super(282);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.xres = this.readReal(imageInputStream);
        }

        public XResolutionDE(double d) throws IOException {
            super(282);
            this.setType(5);
            this.setCount(1L);
            this.xres = d;
        }

        public void write(ImageOutputStream imageOutputStream) throws IOException {
            this.writeReal(imageOutputStream, this.xres);
        }
    }

    public static class StripByteCountsDE
    extends DE {
        private long[] counts;

        public StripByteCountsDE(ImageInputStream imageInputStream) throws IOException {
            super(279);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.counts = this.readIntArray(imageInputStream);
        }

        public long[] getCounts() {
            return this.counts;
        }

        public StripByteCountsDE(int n) throws IOException {
            super(279);
            this.counts = new long[n];
            this.setType(4);
            this.setCount(n);
        }

        public void setCount(int n, long l) {
            this.counts[n] = l;
        }

        public void write(ImageOutputStream imageOutputStream) throws IOException {
            this.writeIntArray(imageOutputStream, this.counts);
        }
    }

    public static class RowsPerStripDE
    extends DE {
        public RowsPerStripDE(ImageInputStream imageInputStream) throws IOException {
            super(278);
            this.read(imageInputStream);
        }

        public RowsPerStripDE(int n) throws IOException {
            super(278);
            this.setType(4);
            this.setCount(1L);
            this.setValue(n);
        }
    }

    public static class SamplesPerPixelDE
    extends DE {
        public SamplesPerPixelDE(ImageInputStream imageInputStream) throws IOException {
            super(277);
            this.read(imageInputStream);
        }

        public SamplesPerPixelDE(int n) throws IOException {
            super(277);
            this.setType(3);
            this.setCount(1L);
            this.setValue(n);
        }
    }

    public static class OrientationDE
    extends DE {
        public OrientationDE(ImageInputStream imageInputStream) throws IOException {
            super(274);
            this.read(imageInputStream);
        }

        public OrientationDE(int n) throws IOException {
            super(274);
            this.setType(3);
            this.setCount(1L);
            this.setValue(n);
        }
    }

    public static class StripOffsetsDE
    extends DE {
        private long[] offsets;

        public StripOffsetsDE(ImageInputStream imageInputStream) throws IOException {
            super(273);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.offsets = this.readIntArray(imageInputStream);
        }

        public long[] getOffsets() {
            return this.offsets;
        }

        public StripOffsetsDE(int n) throws IOException {
            super(273);
            this.offsets = new long[n];
            this.setType(4);
            this.setCount(n);
        }

        public void setOffset(int n, long l) {
            this.offsets[n] = l;
        }

        public void write(ImageOutputStream imageOutputStream) throws IOException {
            this.writeIntArray(imageOutputStream, this.offsets);
        }
    }

    public static class ImageDescriptionDE
    extends DE {
        String name;

        public ImageDescriptionDE(ImageInputStream imageInputStream) throws IOException {
            super(270);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.name = this.readString(imageInputStream)[0];
        }
    }

    public static class DocumentNameDE
    extends DE {
        String name;

        public DocumentNameDE(ImageInputStream imageInputStream) throws IOException {
            super(269);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.name = this.readString(imageInputStream)[0];
        }
    }

    public static class FillOrderDE
    extends DE {
        public FillOrderDE(ImageInputStream imageInputStream) throws IOException {
            super(266);
            this.read(imageInputStream);
        }

        public FillOrderDE(int n) throws IOException {
            super(266);
            this.setType(3);
            this.setCount(1L);
            this.setValue(n);
        }
    }

    public static class PhotometricInterpretationDE
    extends DE {
        public PhotometricInterpretationDE(ImageInputStream imageInputStream) throws IOException {
            super(262);
            this.read(imageInputStream);
        }

        public PhotometricInterpretationDE(int n) throws IOException {
            super(262);
            this.setType(3);
            this.setCount(1L);
            this.setValue(n);
        }
    }

    public static class CompressionDE
    extends DE {
        public CompressionDE(ImageInputStream imageInputStream) throws IOException {
            super(259);
            this.read(imageInputStream);
        }

        public CompressionDE(int n) throws IOException {
            super(259);
            this.setType(3);
            this.setCount(1L);
            this.setValue(n);
        }
    }

    public static class BitsPerSampleDE
    extends DE {
        long[] bps;

        public BitsPerSampleDE(ImageInputStream imageInputStream) throws IOException {
            super(258);
            this.read(imageInputStream);
        }

        public void read(ImageInputStream imageInputStream) throws IOException {
            super.read(imageInputStream);
            this.bps = this.readIntArray(imageInputStream);
        }

        public int getBits(int n) {
            return (int)this.bps[n];
        }

        public long[] getBits() {
            return this.bps;
        }

        public BitsPerSampleDE(int n) throws IOException {
            super(258);
            this.bps = new long[n];
            this.setType(3);
            this.setCount(n);
        }

        public void setBitsPerSample(int n, long l) {
            this.bps[n] = l;
        }

        public void write(ImageOutputStream imageOutputStream) throws IOException {
            this.writeIntArray(imageOutputStream, this.bps);
        }
    }

    public static class ImageLengthDE
    extends DE {
        public ImageLengthDE(ImageInputStream imageInputStream) throws IOException {
            super(257);
            this.read(imageInputStream);
        }

        public ImageLengthDE(int n) throws IOException {
            super(257);
            this.setType(4);
            this.setCount(1L);
            this.setValue(n);
        }
    }

    public static class ImageWidthDE
    extends DE {
        public ImageWidthDE(ImageInputStream imageInputStream) throws IOException {
            super(256);
            this.read(imageInputStream);
        }

        public ImageWidthDE(int n) throws IOException {
            super(256);
            this.setType(4);
            this.setCount(1L);
            this.setValue(n);
        }
    }

    public static class NewSubfileTypeDE
    extends DE {
        public NewSubfileTypeDE(ImageInputStream imageInputStream) throws IOException {
            super(254);
            this.read(imageInputStream);
        }

        public NewSubfileTypeDE(int n) throws IOException {
            super(254);
            this.setType(4);
            this.setCount(1L);
            this.setValue(n);
        }

        static int getDefault() {
            return 0;
        }
    }

    public static class UnknownDE
    extends DE {
        public UnknownDE(int n, ImageInputStream imageInputStream) throws IOException {
            super(n);
            this.read(imageInputStream);
        }
    }
}

