/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Vector;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;
import uk.co.mmscomputing.math.Rational;

abstract class DE
implements TIFFConstants {
    private int tag;
    protected int type;
    protected long len;
    protected long val;

    DE(int n) throws IOException {
        this.tag = n;
    }

    int getTag() {
        return this.tag;
    }

    int getType() {
        return this.type;
    }

    void setType(int n) {
        this.type = n;
    }

    long getCount() {
        return (int)this.len;
    }

    void setCount(long l) {
        this.len = l;
    }

    long getLength() {
        return (int)this.len;
    }

    void setLength(long l) {
        this.len = l;
    }

    long getValue() {
        return this.val;
    }

    void setValue(long l) {
        this.val = l;
    }

    void read(ImageInputStream imageInputStream) throws IOException {
        this.type = imageInputStream.readUnsignedShort();
        this.len = imageInputStream.readUnsignedInt();
        this.val = this.readValue(imageInputStream);
    }

    private long readValue(ImageInputStream imageInputStream) throws IOException {
        long l = 0L;
        int n = this.sizeOfType();
        if (this.len * (long)n <= 4L) {
            l = imageInputStream.readUnsignedInt();
            if (imageInputStream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                switch (this.type) {
                    case 1: 
                    case 6: {
                        long l2 = l & 0xFFL;
                        l = l >> 24 & 0xFFL;
                        l |= l2 << 24 & 0xFFFFFFFFFF000000L;
                        l2 = l & 0xFF00L;
                        l |= l >> 8 & 0xFF00L;
                        l |= l2 << 8 & 0xFF0000L;
                        break;
                    }
                    case 3: 
                    case 8: {
                        long l3 = l & 0xFFFFL;
                        l = l >> 16 & 0xFFFFL;
                        l |= l3 << 16 & 0xFFFFFFFFFFFF0000L;
                    }
                }
            }
        } else {
            l = imageInputStream.readUnsignedInt();
        }
        return l;
    }

    void writeEntry(ImageOutputStream imageOutputStream) throws IOException {
        imageOutputStream.writeShort(this.tag);
        imageOutputStream.writeShort(this.type);
        imageOutputStream.writeInt((int)this.len);
        imageOutputStream.writeInt((int)this.val);
    }

    protected int sizeOfType() {
        switch (this.type) {
            case 1: 
            case 6: 
            case 7: {
                return 1;
            }
            case 3: 
            case 8: {
                return 2;
            }
            case 4: 
            case 9: 
            case 11: {
                return 4;
            }
            case 5: 
            case 10: 
            case 12: {
                return 8;
            }
        }
        return -1;
    }

    protected long readInt(ImageInputStream imageInputStream) throws IOException {
        switch (this.type) {
            case 1: {
                return imageInputStream.readUnsignedByte();
            }
            case 3: {
                return imageInputStream.readUnsignedShort();
            }
            case 4: {
                return imageInputStream.readUnsignedInt();
            }
            case 6: {
                return imageInputStream.read();
            }
            case 8: {
                return imageInputStream.readShort();
            }
            case 9: {
                return imageInputStream.readInt();
            }
        }
        return 0L;
    }

    protected void writeInt(ImageOutputStream imageOutputStream, long l) throws IOException {
        switch (this.type) {
            case 1: {
                imageOutputStream.writeByte((byte)l);
                break;
            }
            case 3: {
                imageOutputStream.writeShort((short)l);
                break;
            }
            case 4: {
                imageOutputStream.writeInt((int)l);
                break;
            }
            case 6: {
                imageOutputStream.write((byte)l);
                break;
            }
            case 8: {
                imageOutputStream.writeShort((short)l);
                break;
            }
            case 9: {
                imageOutputStream.writeInt((int)l);
                break;
            }
        }
    }

    protected String[] readString(ImageInputStream imageInputStream) throws IOException {
        int n;
        Object object;
        if (this.type != 2) {
            return null;
        }
        imageInputStream.mark();
        imageInputStream.seek(this.val);
        Vector<String[]> vector = new Vector<String[]>();
        int n2 = 0;
        while ((long)n2 < this.len) {
            object = "";
            n = imageInputStream.read();
            ++n2;
            while (n != 0 && (long)n2 < this.len) {
                object = (String)object + (char)n;
                n = imageInputStream.read();
                ++n2;
            }
            vector.add((String[])object);
        }
        imageInputStream.reset();
        object = new String[vector.size()];
        for (n = 0; n < ((String[])object).length; ++n) {
            object[n] = (String)vector.get(n);
        }
        return object;
    }

    protected byte[] readByteArray(ImageInputStream imageInputStream) throws IOException {
        if (this.type != 7) {
            return null;
        }
        byte[] byArray = new byte[(int)this.len];
        if (this.len <= 4L) {
            System.out.println("9\b" + this.getClass().getName() + ".readByteArray:\n\tCannot read byte array len<=4 yet.");
        } else {
            imageInputStream.mark();
            imageInputStream.seek(this.val);
            imageInputStream.read(byArray);
            imageInputStream.reset();
        }
        return byArray;
    }

    private double read1Real(ImageInputStream imageInputStream) throws IOException {
        switch (this.type) {
            case 5: {
                return new Rational((int)imageInputStream.readUnsignedInt(), (int)imageInputStream.readUnsignedInt()).doubleValue();
            }
            case 10: {
                return new Rational(imageInputStream.readInt(), imageInputStream.readInt()).doubleValue();
            }
            case 11: {
                return imageInputStream.readFloat();
            }
            case 12: {
                return imageInputStream.readDouble();
            }
        }
        return 0.0;
    }

    protected double readReal(ImageInputStream imageInputStream) throws IOException {
        if (this.type == 11) {
            return this.read1Real(imageInputStream);
        }
        imageInputStream.mark();
        imageInputStream.seek(this.val);
        double d = this.read1Real(imageInputStream);
        imageInputStream.reset();
        return d;
    }

    protected void write1Real(ImageOutputStream imageOutputStream, double d) throws IOException {
        switch (this.type) {
            case 5: {
                Rational rational = new Rational(d);
                imageOutputStream.writeInt(rational.getNumerator());
                imageOutputStream.writeInt(rational.getDenominator());
                break;
            }
            case 10: {
                Rational rational = new Rational(d);
                imageOutputStream.writeInt(rational.getNumerator());
                imageOutputStream.writeInt(rational.getDenominator());
                break;
            }
            case 11: {
                this.val = Float.floatToIntBits((float)d);
                break;
            }
            case 12: {
                imageOutputStream.writeDouble(d);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void writeReal(ImageOutputStream imageOutputStream, double d) throws IOException {
        switch (this.type) {
            case 5: {
                this.val = imageOutputStream.getStreamPosition();
                Rational rational = new Rational(d);
                imageOutputStream.writeInt(rational.getNumerator());
                imageOutputStream.writeInt(rational.getDenominator());
                break;
            }
            case 10: {
                this.val = imageOutputStream.getStreamPosition();
                Rational rational = new Rational(d);
                imageOutputStream.writeInt(rational.getNumerator());
                imageOutputStream.writeInt(rational.getDenominator());
                break;
            }
            case 11: {
                this.val = Float.floatToIntBits((float)d);
                break;
            }
            case 12: {
                this.val = imageOutputStream.getStreamPosition();
                imageOutputStream.writeDouble(d);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected long[] readIntArray(ImageInputStream imageInputStream) throws IOException {
        long[] lArray;
        block9: {
            block8: {
                lArray = new long[(int)this.len];
                int n = this.sizeOfType();
                if (this.len * (long)n > 4L) break block8;
                int n2 = 0;
                switch (n) {
                    case 1: {
                        int n3 = 0;
                        while ((long)n3 < this.len) {
                            lArray[n3] = this.val >> n2 & 0xFFL;
                            n2 += 8;
                            ++n3;
                        }
                        break block9;
                    }
                    case 2: {
                        int n4 = 0;
                        while ((long)n4 < this.len) {
                            lArray[n4] = this.val >> n2 & 0xFFFFL;
                            n2 += 16;
                            ++n4;
                        }
                        break block9;
                    }
                    case 4: {
                        lArray[0] = this.val;
                    }
                }
                break block9;
            }
            imageInputStream.mark();
            imageInputStream.seek(this.val);
            int n = 0;
            while ((long)n < this.len) {
                lArray[n] = this.readInt(imageInputStream);
                ++n;
            }
            imageInputStream.reset();
        }
        return lArray;
    }

    protected void writeIntArray(ImageOutputStream imageOutputStream, long[] lArray) throws IOException {
        block9: {
            block8: {
                int n = this.sizeOfType();
                if (this.len * (long)n > 4L) break block8;
                int n2 = 0;
                switch (n) {
                    case 1: {
                        this.val = 0L;
                        int n3 = 0;
                        while ((long)n3 < this.len) {
                            this.val |= (lArray[n3] & 0xFFL) << n2;
                            n2 += 8;
                            ++n3;
                        }
                        break block9;
                    }
                    case 2: {
                        this.val = 0L;
                        int n4 = 0;
                        while ((long)n4 < this.len) {
                            this.val |= (lArray[n4] & 0xFFFFL) << n2;
                            n2 += 16;
                            ++n4;
                        }
                        break block9;
                    }
                    case 4: {
                        this.val = lArray[0];
                    }
                }
                break block9;
            }
            this.val = imageOutputStream.getStreamPosition();
            int n = 0;
            while ((long)n < this.len) {
                this.writeInt(imageOutputStream, lArray[n]);
                ++n;
            }
        }
    }

    protected double[] readRealArray(ImageInputStream imageInputStream) throws IOException {
        double[] dArray = new double[(int)this.len];
        int n = this.sizeOfType();
        if (this.len * (long)n <= 4L) {
            dArray[0] = Float.intBitsToFloat((int)this.val);
        } else {
            imageInputStream.mark();
            imageInputStream.seek(this.val);
            int n2 = 0;
            while ((long)n2 < this.len) {
                dArray[n2] = this.read1Real(imageInputStream);
                ++n2;
            }
            imageInputStream.reset();
        }
        return dArray;
    }

    protected void writeRealArray(ImageOutputStream imageOutputStream, double[] dArray) throws IOException {
        int n = this.sizeOfType();
        if (this.len * (long)n <= 4L) {
            this.write1Real(imageOutputStream, dArray[0]);
        } else {
            this.val = imageOutputStream.getStreamPosition();
            int n2 = 0;
            while ((long)n2 < this.len) {
                this.write1Real(imageOutputStream, dArray[n2]);
                ++n2;
            }
        }
    }

    protected void writeByteArray(ImageOutputStream imageOutputStream, byte[] byArray) throws IOException {
        int n = this.sizeOfType();
        if (n != 1) {
            throw new IOException(this.getClass().getName() + ".writeByteArray:\n\tInternal error: size of type != 1.");
        }
        if (this.len <= 4L) {
            this.val = 0L;
            int n2 = 0;
            int n3 = 0;
            while ((long)n3 < this.len) {
                this.val |= (long)((byArray[n3] & 0xFF) << n2);
                n2 += 8;
                ++n3;
            }
        } else {
            this.val = imageOutputStream.getStreamPosition();
            imageOutputStream.write(byArray, 0, (int)this.len);
            if ((this.len & 1L) == 1L) {
                imageOutputStream.write(0);
            }
        }
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
    }
}

