/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.sff;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.io.ModHuffmanOutputStream;

public class SFFInputStream
extends FilterInputStream {
    private int resVert;
    private int resHorz;
    private int width;
    private int height;
    private int offset;
    private byte[] data;
    private byte[] lineData = null;
    private int index;
    private int length;
    private boolean eop;
    private byte[] whiteLine;
    private int whiteLines;
    private boolean needToDuplicateLine;
    private boolean duplicateLine;
    private int maxIllegalLineCodings = -1;

    public SFFInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.readHeader();
        if (inputStream.read() != 254) {
            throw new IOException(this.getClass().getName() + ".readHeader\n\tMissing page signature in sff fax document");
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isEndOfPage() {
        return this.eop;
    }

    public void setMaxAllowedIllegalLineCodings(int n) {
        this.maxIllegalLineCodings = n;
    }

    public int getVerticalResolution() {
        switch (this.resVert) {
            case 0: 
            case 1: {
                return 196;
            }
        }
        return 0;
    }

    public int getHorizontalResolution() {
        switch (this.resHorz) {
            case 0: {
                return 203;
            }
        }
        return 0;
    }

    public boolean hasImage() throws IOException {
        this.data = null;
        this.index = 0;
        this.length = 0;
        this.height = 0;
        this.eop = false;
        this.whiteLines = 0;
        this.whiteLine = null;
        this.duplicateLine = true;
        return this.readImageHeader();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 < 0) {
                if (i > 0) {
                    return i;
                }
                return -1;
            }
            byArray[n + i] = (byte)n3;
        }
        return n2;
    }

    public int read() throws IOException {
        if (this.index >= this.length) {
            if (0 < this.whiteLines) {
                --this.whiteLines;
            } else {
                if (this.eop) {
                    return -1;
                }
                this.length = this.readLine();
                if (this.length == -1) {
                    return -1;
                }
            }
            ++this.height;
            this.index = 0;
        }
        return this.data[this.index++] & 0xFF;
    }

    private int readUnsignedShort() throws IOException {
        int n = this.in.read() & 0xFF;
        return n |= (this.in.read() & 0xFF) << 8;
    }

    private int readInt() throws IOException {
        int n = this.in.read() & 0xFF;
        n |= (this.in.read() & 0xFF) << 8;
        n |= (this.in.read() & 0xFF) << 16;
        return n |= (this.in.read() & 0xFF) << 24;
    }

    private void skipBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.in.read(byArray);
    }

    private int readLine() throws IOException {
        int n;
        this.eop = false;
        if (this.needToDuplicateLine) {
            boolean bl = this.duplicateLine = !this.duplicateLine;
            if (this.duplicateLine) {
                return this.length;
            }
        }
        if ((n = this.in.read()) == -1) {
            this.eop = true;
            System.err.println(this.getClass().getName() + ".readLine:\n\tMissing page header.");
            return -1;
        }
        if (n == 0) {
            n = this.readUnsignedShort();
            this.data = this.lineData;
            this.in.read(this.data, 0, n);
            this.data[n] = 0;
            this.data[n + 1] = -128;
            return n + 2;
        }
        if (n <= 216) {
            this.data = this.lineData;
            this.in.read(this.data, 0, n);
            this.data[n] = 0;
            this.data[n + 1] = -128;
            return n + 2;
        }
        if (n <= 253) {
            if (this.whiteLine == null) {
                this.whiteLine = this.getWhiteLineCode(this.width);
            }
            this.whiteLines = n - 216 - 1;
            this.data = this.whiteLine;
            return this.whiteLine.length;
        }
        if (n == 254) {
            this.eop = true;
            return -1;
        }
        n = this.in.read();
        if (n == 0) {
            if (this.maxIllegalLineCodings == 0) {
                throw new IllegalLineCodingException(this.getClass().getName() + ".readLine :\n\tToo many illegal line codings.");
            }
            --this.maxIllegalLineCodings;
            if (this.whiteLine == null) {
                this.whiteLine = this.getWhiteLineCode(this.width);
            }
            this.data = this.whiteLine;
            return this.whiteLine.length;
        }
        System.err.println(this.getClass().getName() + ".readLine:\n\tReceived additional user information.");
        byte[] byArray = new byte[n & 0xFF];
        this.in.read(byArray);
        for (int i = 0; i < byArray.length; ++i) {
            System.err.println("info[" + i + "] = 0x" + Integer.toHexString(byArray[i]));
        }
        return this.readLine();
    }

    private byte[] getWhiteLineCode(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ModHuffmanOutputStream modHuffmanOutputStream = new ModHuffmanOutputStream(byteArrayOutputStream);
        modHuffmanOutputStream.write(n);
        modHuffmanOutputStream.flush();
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(128);
        modHuffmanOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void readHeader() throws IOException {
        byte[] byArray = new byte[4];
        this.in.read(byArray);
        if (byArray[0] != 83 || byArray[1] != 102 || byArray[2] != 102 || byArray[3] != 102) {
            throw new IOException(this.getClass().getName() + ".readHeader:\n\tInvalid sff fax document : Magic value is missing.");
        }
        int n = this.readUnsignedShort();
        if (n != 1) {
            throw new IOException(this.getClass().getName() + ".readHeader:\n\tUnknown file version [" + n + "]");
        }
        int n2 = this.readUnsignedShort();
        int n3 = this.readUnsignedShort();
        int n4 = this.readUnsignedShort();
        int n5 = this.readInt();
        int n6 = this.readInt();
        this.skipBytes(n4 - 20);
    }

    private boolean readImageHeader() throws IOException {
        int n = this.in.read();
        if (n <= 0) {
            if (n == -1) {
                System.err.println(this.getClass().getName() + ".readHeader:\n\tMissing page header.");
            } else {
                int n2 = this.in.read();
                if (n2 != -1) {
                    System.err.println(this.getClass().getName() + ".readHeader:\n\tAdditional data after end of document.");
                    while ((n2 = this.in.read()) > 0) {
                    }
                }
            }
            return false;
        }
        this.resVert = this.in.read();
        if (this.resVert == 255) {
            return false;
        }
        this.needToDuplicateLine = this.resVert == 0;
        this.resHorz = this.in.read();
        int n3 = this.in.read();
        if (n3 != 0) {
            throw new IOException(this.getClass().getName() + ".readPageHeader:\n\tDo not know how to handle this sff page coding [" + n3 + "].");
        }
        this.in.read();
        this.width = this.readUnsignedShort();
        if (this.lineData == null || this.lineData.length < this.width) {
            this.lineData = new byte[this.width];
        }
        int n4 = this.readUnsignedShort();
        int n5 = this.readInt();
        int n6 = this.readInt();
        this.skipBytes(n - 16);
        return true;
    }

    public static class IllegalLineCodingException
    extends IOException {
        public IllegalLineCodingException(String string) {
            super(string);
        }
    }
}

