/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.sff;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import uk.co.mmscomputing.imageio.sff.SFFInputStream;
import uk.co.mmscomputing.io.ModHuffmanInputStream;
import uk.co.mmscomputing.io.RLEBitInputStream;

public class SFFImageReader
extends ImageReader {
    private Vector ifds = null;

    protected SFFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.readIFDs();
        this.checkIndex(n);
        return this.readImage((IFD)this.ifds.elementAt(n));
    }

    public int getHeight(int n) throws IOException {
        this.readIFDs();
        this.checkIndex(n);
        return ((IFD)this.ifds.elementAt((int)n)).height;
    }

    public int getWidth(int n) throws IOException {
        this.readIFDs();
        this.checkIndex(n);
        return ((IFD)this.ifds.elementAt((int)n)).width;
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.readIFDs();
        this.checkIndex(n);
        ImageTypeSpecifier imageTypeSpecifier = null;
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(12);
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    public int getNumImages(boolean bl) throws IOException {
        this.readIFDs();
        return this.ifds.size();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.readIFDs();
        this.checkIndex(n);
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    private void checkIndex(int n) {
        if (n >= this.ifds.size()) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".checkIndex:\n\tBad index in sff image reader");
        }
    }

    private byte[] readImageData() throws IOException {
        byte[] byArray;
        ImageInputStream imageInputStream = (ImageInputStream)this.getInput();
        int n = (int)imageInputStream.length();
        if (n == -1) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byArray = new byte[8192];
            while ((n = imageInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            byArray = new byte[n];
            imageInputStream.readFully(byArray, 0, n);
        }
        return byArray;
    }

    private IFD readIFD(SFFInputStream sFFInputStream) throws IOException {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            while (!sFFInputStream.isEndOfPage() && (n = sFFInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            IFD iFD = new IFD();
            iFD.width = sFFInputStream.getWidth();
            iFD.height = sFFInputStream.getHeight();
            iFD.data = byteArrayOutputStream.toByteArray();
            return iFD;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(this.getClass().getName() + ".readIFD:\n\t" + exception.getMessage());
        }
    }

    private void readIFDs() throws IOException {
        if (this.ifds == null) {
            this.ifds = new Vector();
            byte[] byArray = this.readImageData();
            SFFInputStream sFFInputStream = new SFFInputStream(new ByteArrayInputStream(byArray));
            while (sFFInputStream.hasImage()) {
                this.ifds.add(this.readIFD(sFFInputStream));
            }
        }
    }

    private BufferedImage readImage(IFD iFD) throws IOException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(iFD.data);
            ModHuffmanInputStream modHuffmanInputStream = new ModHuffmanInputStream(byteArrayInputStream);
            RLEBitInputStream rLEBitInputStream = new RLEBitInputStream(modHuffmanInputStream);
            BufferedImage bufferedImage = new BufferedImage(iFD.width, iFD.height, 12);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            if (iFD.width % 8 == 0) {
                byte[] byArray2 = new byte[iFD.width >> 3];
                int n = 0;
                int n2 = 0;
                while (true) {
                    try {
                        n2 = rLEBitInputStream.read(byArray2);
                        if (n2 == -1) break;
                        System.arraycopy(byArray2, 0, byArray, n, n2);
                    }
                    catch (ModHuffmanInputStream.ModHuffmanCodingException modHuffmanCodingException) {
                        System.err.println(this.getClass().getName() + ".readImage\n\t" + modHuffmanCodingException.getMessage());
                    }
                    modHuffmanInputStream.syncWithEOL();
                    rLEBitInputStream.resetToStartCodeWord();
                    n += n2;
                }
                return bufferedImage;
            }
            byte[] byArray3 = new byte[iFD.width + 7 >> 3];
            int n = 0;
            int n3 = 0;
            int n4 = 8 - (iFD.width & 7);
            while (true) {
                try {
                    n3 = rLEBitInputStream.read(byArray3, 0, byArray3.length - 1);
                    if (n3 == -1) break;
                    int n5 = rLEBitInputStream.readBits(7, n4);
                    byArray3[n3] = (byte)n5;
                    System.arraycopy(byArray3, 0, byArray, n, n3 + 1);
                }
                catch (ModHuffmanInputStream.ModHuffmanCodingException modHuffmanCodingException) {
                    System.err.println(this.getClass().getName() + ".readImage\n\t" + modHuffmanCodingException.getMessage());
                }
                modHuffmanInputStream.syncWithEOL();
                rLEBitInputStream.resetToStartCodeWord();
                n += n3 + 1;
            }
            return bufferedImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(this.getClass().getName() + ".readImage:\n\t" + exception.getMessage());
        }
    }

    private static class IFD {
        int width = 0;
        int height = 0;
        byte[] data = null;

        private IFD() {
        }
    }
}

