/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.ppm;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class PPMImageWriter
extends ImageWriter {
    protected PPMImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public boolean canInsertImage(int n) throws IOException {
        super.canInsertImage(n);
        return n == 0;
    }

    public void ppm(ImageOutputStream imageOutputStream, BufferedImage bufferedImage) throws IOException {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(this.getClass().getName() + ".ppm: couldn't grab pixels from image !");
        }
        String string = "P6\n" + n + " " + n2 + "\n255\n";
        imageOutputStream.write(string.getBytes());
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n3 = 0;
        byte[] byArray = new byte[n * n2 * 3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = nArray[i * n + j];
                byArray[n3++] = (byte)colorModel.getRed(n4);
                byArray[n3++] = (byte)colorModel.getGreen(n4);
                byArray[n3++] = (byte)colorModel.getBlue(n4);
            }
        }
        imageOutputStream.write(byArray);
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.getOutput();
        if (!(iIOImage.getRenderedImage() instanceof BufferedImage)) {
            throw new IOException(this.getClass().getName() + "write: Can only write BufferedImage objects");
        }
        BufferedImage bufferedImage = (BufferedImage)iIOImage.getRenderedImage();
        this.ppm(imageOutputStream, bufferedImage);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(this.getLocale());
    }
}

