/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.ppm;

import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.image.operators.GrayScale;
import uk.co.mmscomputing.imageio.ppm.PPMConstants;

public class PGMImageWriter
extends ImageWriter
implements PPMConstants {
    protected PGMImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public boolean canInsertImage(int n) throws IOException {
        super.canInsertImage(n);
        return n == 0;
    }

    public void pgm(ImageOutputStream imageOutputStream, BufferedImage bufferedImage) throws IOException {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, n, n2, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(this.getClass().getName() + ".pgm: couldn't grab pixels from image !");
        }
        String string = "P5\n" + n + " " + n2 + "\n255\n";
        imageOutputStream.write(string.getBytes());
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = 0;
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                byArray[n3++] = (byte)writableRaster.getSample(j, i, 0);
            }
        }
        imageOutputStream.write(byArray);
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.getOutput();
        if (!(iIOImage.getRenderedImage() instanceof BufferedImage)) {
            throw new IOException(this.getClass().getName() + "write: Can only write BufferedImage objects");
        }
        BufferedImage bufferedImage = (BufferedImage)iIOImage.getRenderedImage();
        if (bufferedImage.getType() != 10) {
            bufferedImage = new GrayScale().filter(bufferedImage);
        }
        this.pgm(imageOutputStream, bufferedImage);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(this.getLocale());
    }
}

