/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.pdf.PDFArray;
import uk.co.mmscomputing.imageio.pdf.PDFDictionary;
import uk.co.mmscomputing.imageio.pdf.PDFFile;
import uk.co.mmscomputing.imageio.pdf.PDFFilter;
import uk.co.mmscomputing.imageio.pdf.PDFObject;
import uk.co.mmscomputing.imageio.pdf.PDFScanner;

public class PDFStream
extends PDFObject {
    protected PDFDictionary dict = null;
    protected InputStream data = null;

    public PDFStream() {
        this(new PDFDictionary());
    }

    public PDFStream(PDFDictionary pDFDictionary) {
        this.dict = pDFDictionary;
    }

    public void setInputStream(byte[] byArray) {
        this.data = new ByteArrayInputStream(byArray);
    }

    public void setInputStream(InputStream inputStream) {
        this.data = inputStream;
    }

    public InputStream getInputStream() {
        return this.data;
    }

    public void put(String string, PDFObject pDFObject) {
        this.dict.put(string, pDFObject);
    }

    public PDFObject get(String string) {
        return this.dict.get(string);
    }

    public void setFilter(String string) {
        this.put("Filter", new PDFObject.PDFName(string));
    }

    public void setFilters(String[] stringArray) {
        PDFArray pDFArray = new PDFArray();
        for (int i = 0; i < stringArray.length; ++i) {
            pDFArray.add(new PDFObject.PDFName(stringArray[i]));
        }
        this.put("Filter", pDFArray);
    }

    public String[] getFilters() {
        PDFObject pDFObject = this.get("Filter");
        if (pDFObject instanceof PDFObject.PDFName) {
            String[] stringArray = new String[]{((PDFObject.PDFName)pDFObject).getName()};
            return stringArray;
        }
        if (pDFObject instanceof PDFArray) {
            PDFArray pDFArray = (PDFArray)pDFObject;
            String[] stringArray = new String[pDFArray.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((PDFObject.PDFName)pDFArray.elementAt(i)).getName();
            }
            return stringArray;
        }
        throw new IllegalArgumentException(this.getClass().getName() + ".getFilters:\n\t'Filter' has unknown type");
    }

    public void read(PDFScanner pDFScanner) throws IOException {
        PDFObject pDFObject = this.dict.getObject("Length");
        int n = ((PDFObject.PDFInteger)pDFObject).getValue();
        this.setInputStream(pDFScanner.scanStream(n));
        pDFScanner.scan();
        if (pDFScanner.symbol != 404) {
            throw new IOException(this.getClass().getName() + ".read:\n\tCannot find keyword <endstream>.\nHave symbol = " + pDFScanner.symbol + " and string = " + pDFScanner.str);
        }
        pDFScanner.scan();
    }

    private byte[] codeNone(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void write(PDFFile pDFFile) throws IOException {
        byte[] byArray;
        if (this.data == null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PDFObject pDFObject = this.get("Filter");
        if (pDFObject == null) {
            byArray = this.codeNone(this.data);
        } else if (pDFObject instanceof PDFObject.PDFName) {
            int n;
            PDFFilter.PDFEncoder pDFEncoder = PDFFilter.getEncoder((OutputStream)byteArrayOutputStream, this.dict, (PDFObject.PDFName)pDFObject);
            byArray = new byte[4096];
            while ((n = this.data.read(byArray)) != -1) {
                pDFEncoder.write(byArray, 0, n);
            }
            pDFEncoder.close();
            byArray = byteArrayOutputStream.toByteArray();
        } else if (pDFObject instanceof PDFArray) {
            int n;
            PDFFilter.PDFEncoder pDFEncoder = PDFFilter.getEncoder((OutputStream)byteArrayOutputStream, this.dict, (PDFArray)pDFObject);
            byArray = new byte[4096];
            while ((n = this.data.read(byArray)) != -1) {
                pDFEncoder.write(byArray, 0, n);
            }
            pDFEncoder.close();
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            throw new IOException(this.getClass().getName() + ".write:\n\tUnknown filter object.");
        }
        this.put("Length", new PDFObject.PDFInteger(byArray.length));
        this.dict.write(pDFFile);
        pDFFile.write("stream\r\n");
        pDFFile.write(byArray);
        pDFFile.writeln("\rendstream");
    }

    public String toString() {
        String string = this.dict.toString();
        string = string + "stream\r\n...\rendstream";
        return string;
    }
}

