/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.IOException;
import uk.co.mmscomputing.imageio.pdf.PDFArray;
import uk.co.mmscomputing.imageio.pdf.PDFConstants;
import uk.co.mmscomputing.imageio.pdf.PDFDictionary;
import uk.co.mmscomputing.imageio.pdf.PDFFile;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectReference;
import uk.co.mmscomputing.imageio.pdf.PDFScanner;
import uk.co.mmscomputing.imageio.pdf.PDFStream;
import uk.co.mmscomputing.imageio.pdf.PDFXObject;

public abstract class PDFObject
implements PDFConstants {
    public void write(PDFFile pDFFile) throws IOException {
        pDFFile.write(this.toString());
    }

    public void read(PDFScanner pDFScanner) throws IOException {
        System.err.println("\n\nNOT IMPLEMENTED YET\n\n");
        new Exception().printStackTrace();
    }

    public static PDFObject readObject(PDFScanner pDFScanner) throws IOException {
        PDFObject pDFObject = null;
        switch (pDFScanner.symbol) {
            case 203: {
                pDFObject = new PDFString(pDFScanner.str);
                pDFScanner.scan();
                break;
            }
            case 306: {
                pDFObject = new PDFName(pDFScanner.str);
                pDFScanner.scan();
                break;
            }
            case 402: {
                pDFObject = new PDFBoolean(true);
                pDFScanner.scan();
                break;
            }
            case 401: {
                pDFObject = new PDFBoolean(false);
                pDFScanner.scan();
                break;
            }
            case 400: {
                pDFObject = new PDFNull();
                pDFScanner.scan();
                break;
            }
            case 201: {
                pDFObject = new PDFInteger(pDFScanner.intval);
                pDFScanner.scan();
                break;
            }
            case 202: {
                pDFObject = new PDFReal(pDFScanner.realval);
                pDFScanner.scan();
                break;
            }
            case 407: {
                pDFObject = new PDFIndirectReference(pDFScanner.getIndirectObject(pDFScanner.objectNumber, pDFScanner.generationNumber));
                pDFScanner.scan();
                break;
            }
            case 302: {
                pDFObject = new PDFArray();
                pDFObject.read(pDFScanner);
                pDFScanner.scan();
                return pDFObject;
            }
            case 303: {
                return null;
            }
            case 304: {
                PDFDictionary pDFDictionary = new PDFDictionary();
                pDFDictionary.read(pDFScanner);
                pDFScanner.scan();
                if (pDFScanner.symbol == 403) {
                    if (pDFDictionary.checkNameEntry("Type", "XObject")) {
                        return PDFXObject.readXObject(pDFScanner, pDFDictionary);
                    }
                    pDFObject = new PDFStream(pDFDictionary);
                    pDFObject.read(pDFScanner);
                    return pDFObject;
                }
                return pDFDictionary;
            }
            case 305: {
                return null;
            }
            default: {
                System.err.println("symbol    = " + pDFScanner.symbol);
            }
        }
        return pDFObject;
    }

    public static class PDFName
    extends PDFObject {
        private String name = "";

        public PDFName(String string) {
            this.set(string);
        }

        public void set(String string) {
            this.name = "";
            byte[] byArray = string.getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                char c = (char)byArray[i];
                switch (c) {
                    case '\n': 
                    case '\r': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '<': 
                    case '>': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        System.err.println(this.getClass().getName() + ".set:\n\tInvalid character " + string);
                        throw new IllegalArgumentException(this.getClass().getName() + ".set\n\tInvalid character " + c);
                    }
                }
                this.name = this.name + c;
            }
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "/" + this.name + " ";
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            return object.equals(this.name);
        }
    }

    public static class PDFHexString
    extends PDFObject {
        private String value = "";

        public PDFHexString(String string) {
            this.value = string;
        }

        public void setValue(String string) {
            this.value = string.length() % 2 == 0 ? string : string + "0";
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            String string = "<";
            byte[] byArray = this.value.getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                if (48 <= by && by <= 57) {
                    string = string + by;
                    continue;
                }
                if (65 <= by && by <= 70) {
                    string = string + by;
                    continue;
                }
                if (97 > by || by > 102) continue;
                string = string + by;
            }
            string = string + "> ";
            return string;
        }
    }

    public static class PDFString
    extends PDFObject {
        private String value = "";

        public PDFString(String string) {
            this.value = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            String string = "(";
            byte[] byArray = this.value.getBytes();
            block10: for (int i = 0; i < byArray.length; ++i) {
                char c = (char)byArray[i];
                switch (c) {
                    case '\n': {
                        string = string + "\\n";
                        continue block10;
                    }
                    case '\r': {
                        string = string + "\\r";
                        continue block10;
                    }
                    case '\t': {
                        string = string + "\\t";
                        continue block10;
                    }
                    case '\b': {
                        string = string + "\\b";
                        continue block10;
                    }
                    case '\f': {
                        string = string + "\\f";
                        continue block10;
                    }
                    case '(': {
                        string = string + "\\(";
                        continue block10;
                    }
                    case ')': {
                        string = string + "\\)";
                        continue block10;
                    }
                    case '\\': {
                        string = string + "\\\\";
                        continue block10;
                    }
                    default: {
                        string = string + c;
                    }
                }
            }
            string = string + ") ";
            return string;
        }
    }

    public static class PDFReal
    extends PDFObject {
        private double value = 0.0;

        public PDFReal(double d) {
            this.value = d;
        }

        public void setValue(double d) {
            this.value = d;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return "" + this.value + " ";
        }
    }

    public static class PDFInteger
    extends PDFObject {
        private int value = 0;

        public PDFInteger(int n) {
            this.value = n;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return "" + this.value + " ";
        }
    }

    public static class PDFBoolean
    extends PDFObject {
        private boolean value = true;

        public PDFBoolean(boolean bl) {
            this.value = bl;
        }

        public void setValue(boolean bl) {
            this.value = bl;
        }

        public boolean getValue() {
            return this.value;
        }

        public String toString() {
            return this.value ? "true " : "false ";
        }
    }

    public static class PDFNull
    extends PDFObject {
        public String toString() {
            return "null";
        }
    }
}

