/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.IOException;
import uk.co.mmscomputing.imageio.pdf.PDFCrossReferenceEntry;
import uk.co.mmscomputing.imageio.pdf.PDFFile;
import uk.co.mmscomputing.imageio.pdf.PDFObject;
import uk.co.mmscomputing.imageio.pdf.PDFScanner;

public class PDFIndirectObject
extends PDFObject {
    private int objectNumber;
    private int generationNumber;
    private int offset;
    private PDFObject directObject;

    public PDFIndirectObject(int n, int n2, boolean bl) {
        this.objectNumber = n;
        this.generationNumber = n2;
        this.directObject = null;
        this.offset = -1;
    }

    public PDFIndirectObject(int n, PDFObject pDFObject) {
        this.objectNumber = n;
        this.generationNumber = 0;
        this.directObject = pDFObject;
        this.offset = -1;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public void setObjectNumber(int n) {
        this.objectNumber = n;
    }

    public int getObjectNumber() {
        return this.objectNumber;
    }

    public void setGenerationNumber(int n) {
        this.generationNumber = n;
    }

    public int getGenerationNumber() {
        return this.generationNumber;
    }

    public void setDirectObject(PDFObject pDFObject) {
        this.directObject = pDFObject;
    }

    public PDFObject getDirectObject() {
        return this.directObject;
    }

    public void read(PDFScanner pDFScanner) throws IOException {
        if (pDFScanner.symbol != 201) {
            throw new IOException(this.getClass().getName() + ".read:\n\tCannot find 'object number'.");
        }
        this.setObjectNumber(pDFScanner.intval);
        pDFScanner.scan();
        if (pDFScanner.symbol != 201) {
            throw new IOException(this.getClass().getName() + ".read:\n\tCannot find 'generation number'.");
        }
        this.setGenerationNumber(pDFScanner.intval);
        pDFScanner.scan();
        if (pDFScanner.symbol != 405) {
            throw new IOException(this.getClass().getName() + ".read:\n\tCannot find keyword <obj>.");
        }
        pDFScanner.scan();
        this.directObject = PDFObject.readObject(pDFScanner);
        if (pDFScanner.symbol != 406) {
            throw new IOException(this.getClass().getName() + ".read:\n\tCannot find keyword <endobj>.");
        }
        pDFScanner.scan();
    }

    public void write(PDFFile pDFFile) throws IOException {
        if (this.directObject != null) {
            this.offset = pDFFile.getOffset();
            pDFFile.write(this.objectNumber);
            pDFFile.write(' ');
            pDFFile.write(this.generationNumber);
            pDFFile.write(' ');
            pDFFile.writeln("obj");
            this.directObject.write(pDFFile);
            pDFFile.writeln("endobj");
        }
    }

    public String toString() {
        String string = "\nNo Direct Object\n";
        if (this.directObject != null) {
            string = this.getObjectNumber() + " " + this.getGenerationNumber() + " obj ";
            string = string + this.directObject.toString();
            string = string + "endobj ";
        }
        return string;
    }

    public PDFCrossReferenceEntry getXRefEntry() {
        if (this.directObject != null) {
            PDFCrossReferenceEntry pDFCrossReferenceEntry = new PDFCrossReferenceEntry(this.objectNumber);
            pDFCrossReferenceEntry.setOffset(this.offset);
            return pDFCrossReferenceEntry;
        }
        return new PDFCrossReferenceEntry(this.objectNumber, this.generationNumber);
    }
}

