/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.imageio.pdf.PDFFile;
import uk.co.mmscomputing.imageio.pdf.PDFImageWriteParam;
import uk.co.mmscomputing.imageio.pdf.PDFPage;

public class PDFImageWriter
extends ImageWriter {
    private PDFFile pdffile;
    private int index = 0;

    protected PDFImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new PDFImageWriteParam(this.getLocale());
    }

    public boolean canInsertImage(int n) throws IOException {
        super.canInsertImage(n);
        return n == 0;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.prepareWriteSequence(iIOMetadata);
        this.writeToSequence(iIOImage, imageWriteParam);
        this.endWriteSequence();
    }

    public boolean canWriteSequence() {
        return true;
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        this.pdffile = new PDFFile();
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (!(iIOImage.getRenderedImage() instanceof BufferedImage)) {
            throw new IOException(this.getClass().getName() + ".writeToSequence:\n\tCan only write BufferedImage objects");
        }
        BufferedImage bufferedImage = (BufferedImage)iIOImage.getRenderedImage();
        PDFPage pDFPage = this.pdffile.getNewPage();
        String string = "image" + this.index++;
        pDFPage.addImage(string, bufferedImage);
    }

    public void endWriteSequence() throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.pdffile.write(byteArrayOutputStream);
            ImageOutputStream imageOutputStream = (ImageOutputStream)this.getOutput();
            imageOutputStream.write(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

