/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import uk.co.mmscomputing.imageio.pdf.PDFFile;

public class PDFImageReader
extends ImageReader {
    private Vector images;

    protected PDFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.readImages();
        this.checkIndex(n);
        return (BufferedImage)this.images.elementAt(n);
    }

    public int getHeight(int n) throws IOException {
        this.readImages();
        this.checkIndex(n);
        return ((BufferedImage)this.images.elementAt(n)).getHeight();
    }

    public int getWidth(int n) throws IOException {
        this.readImages();
        this.checkIndex(n);
        return ((BufferedImage)this.images.elementAt(n)).getWidth();
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.readImages();
        this.checkIndex(n);
        ImageTypeSpecifier imageTypeSpecifier = null;
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    public int getNumImages(boolean bl) throws IOException {
        this.readImages();
        return this.images.size();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.readImages();
        this.checkIndex(n);
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    private void checkIndex(int n) {
        if (n > this.images.size()) {
            throw new IndexOutOfBoundsException("\n" + this.getClass().getName() + ".checkIndex:\n\tBad index in image reader");
        }
    }

    private void readImages() throws IOException {
        if (this.images == null) {
            try {
                BufferedImage bufferedImage;
                this.images = new Vector();
                PDFFile pDFFile = new PDFFile();
                pDFFile.read((ImageInputStream)this.getInput());
                int n = 0;
                while ((bufferedImage = pDFFile.getImage(n)) != null) {
                    this.images.add(bufferedImage);
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException(this.getClass().getName() + ".readImages:\n\t" + exception);
            }
        }
    }
}

