/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.imageio.jpeg.JFIFInputStream;
import uk.co.mmscomputing.imageio.jpeg.JFIFOutputStream;
import uk.co.mmscomputing.imageio.pdf.PDFDictionary;
import uk.co.mmscomputing.imageio.pdf.PDFObject;
import uk.co.mmscomputing.imageio.pdf.PDFScanner;
import uk.co.mmscomputing.imageio.pdf.PDFXObject;
import uk.co.mmscomputing.io.BitSwapInputStream;
import uk.co.mmscomputing.io.BitSwapOutputStream;
import uk.co.mmscomputing.io.ModHuffmanInputStream;
import uk.co.mmscomputing.io.ModHuffmanOutputStream;
import uk.co.mmscomputing.io.ModModREADInputStream;
import uk.co.mmscomputing.io.ModModREADOutputStream;
import uk.co.mmscomputing.io.RLEBit1OutputStream;
import uk.co.mmscomputing.io.RLEBitInputStream;

public class PDFImage
extends PDFXObject {
    private int imageType = -1;

    public PDFImage(String string, BufferedImage object) throws IOException {
        super("Image");
        Object object2;
        int n = ((BufferedImage)object).getWidth();
        int n2 = ((BufferedImage)object).getHeight();
        this.put("Name", new PDFObject.PDFName(string));
        this.put("Width", new PDFObject.PDFInteger(n));
        this.put("Height", new PDFObject.PDFInteger(n2));
        ColorModel colorModel = ((BufferedImage)object).getColorModel();
        if (((BufferedImage)object).getType() == 12 && colorModel.getPixelSize() == 1) {
            this.put("BitsPerComponent", new PDFObject.PDFInteger(1));
            this.put("ColorSpace", new PDFObject.PDFName("DeviceGray"));
            this.setFilter("CCITTFaxDecode");
            object2 = new PDFDictionary();
            ((PDFDictionary)object2).put("K", new PDFObject.PDFInteger(-1));
            ((PDFDictionary)object2).put("Columns", new PDFObject.PDFInteger(n));
            ((PDFDictionary)object2).put("Rows", new PDFObject.PDFInteger(n2));
            this.put("DecodeParms", (PDFObject)object2);
        } else if (((BufferedImage)object).getType() == 10) {
            System.out.println(this.getClass().getName() + "\n\tPDF JPEG GRAYSCALE\n\t" + string);
            this.put("BitsPerComponent", new PDFObject.PDFInteger(8));
            this.put("ColorSpace", new PDFObject.PDFName("DeviceGray"));
            object2 = new String[]{"DCTDecode"};
            this.setFilters((String[])object2);
        } else {
            System.out.println(this.getClass().getName() + "\tPDF JPEG RGB");
            if (((BufferedImage)object).getType() != 1) {
                object2 = new BufferedImage(n, n2, 1);
                ColorSpace colorSpace = ((BufferedImage)object).getColorModel().getColorSpace();
                ColorSpace colorSpace2 = ((BufferedImage)object2).getColorModel().getColorSpace();
                ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, colorSpace2, null);
                colorConvertOp.filter((BufferedImage)object, (BufferedImage)object2);
                object = object2;
            }
            this.put("BitsPerComponent", new PDFObject.PDFInteger(8));
            this.put("ColorSpace", new PDFObject.PDFName("DeviceRGB"));
            object2 = new String[]{"DCTDecode"};
            this.setFilters((String[])object2);
        }
        object2 = new ByteArrayOutputStream();
        if (((BufferedImage)object).getType() == 12) {
            this.encodeCCITT((ByteArrayOutputStream)object2, (BufferedImage)object);
        } else if (((BufferedImage)object).getType() == 10) {
            this.encodeJPEG((ByteArrayOutputStream)object2, (BufferedImage)object);
        } else {
            this.encodeJPEG((ByteArrayOutputStream)object2, (BufferedImage)object);
        }
        this.setInputStream(((ByteArrayOutputStream)object2).toByteArray());
    }

    private void encodeCCITT(ByteArrayOutputStream byteArrayOutputStream, BufferedImage bufferedImage) throws IOException {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        BitSwapOutputStream bitSwapOutputStream = new BitSwapOutputStream(byteArrayOutputStream);
        ModModREADOutputStream modModREADOutputStream = new ModModREADOutputStream(bitSwapOutputStream, n);
        RLEBit1OutputStream rLEBit1OutputStream = new RLEBit1OutputStream(modModREADOutputStream);
        int n3 = n >> 3;
        int n4 = 8 - (n & 7);
        int n5 = 0;
        if (n4 == 8) {
            for (int i = 0; i < n2; ++i) {
                rLEBit1OutputStream.setStartCodeWord(1);
                ((ModHuffmanOutputStream)modModREADOutputStream).writeEOL();
                rLEBit1OutputStream.write(byArray, n5, n3);
                rLEBit1OutputStream.flush();
                n5 += n3;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                rLEBit1OutputStream.setStartCodeWord(1);
                ((ModHuffmanOutputStream)modModREADOutputStream).writeEOL();
                rLEBit1OutputStream.write(byArray, n5, n3);
                rLEBit1OutputStream.writeBits(byArray[n5 + n3], 7, n4);
                rLEBit1OutputStream.flush();
                n5 += n3 + 1;
            }
        }
        if (modModREADOutputStream instanceof ModModREADOutputStream) {
            modModREADOutputStream.writeEOFB();
        }
        rLEBit1OutputStream.close();
    }

    private void encodeJPEG(ByteArrayOutputStream byteArrayOutputStream, BufferedImage bufferedImage) throws IOException {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage.getType() == 10) {
            JFIFOutputStream jFIFOutputStream = new JFIFOutputStream(byteArrayOutputStream, false, n2, n);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            jFIFOutputStream.write(byArray);
            jFIFOutputStream.close();
        } else if (bufferedImage.getType() == 1) {
            JFIFOutputStream jFIFOutputStream = new JFIFOutputStream(byteArrayOutputStream, true, n2, n);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            jFIFOutputStream.write(nArray);
            jFIFOutputStream.close();
        }
    }

    public PDFImage(PDFDictionary pDFDictionary) {
        super(pDFDictionary);
    }

    public void read(PDFScanner pDFScanner) throws IOException {
        String string;
        int n;
        super.read(pDFScanner);
        String[] stringArray = this.getFilters();
        for (n = 0; n < stringArray.length - 1; ++n) {
        }
        String string2 = stringArray[n];
        if (string2.equals("DCTDecode")) {
            String string3 = ((PDFObject.PDFName)this.get("ColorSpace")).getName();
            if (string3.equals("DeviceGray")) {
                this.imageType = 10;
                return;
            }
            if (string3.equals("DeviceRGB")) {
                this.imageType = 1;
                return;
            }
            throw new IOException(this.getClass().getName() + ".read:\n\tCannot read image stream. Unknown 'ColorSpace' " + string3 + ".");
        }
        if (string2.equals("CCITTFaxDecode") && (string = ((PDFObject.PDFName)this.get("ColorSpace")).getName()).equals("DeviceGray")) {
            this.imageType = 12;
            return;
        }
        throw new IOException(this.getClass().getName() + ".read:\n\tCannot read image stream. Unknown 'Filter' " + string2 + ".");
    }

    public BufferedImage getImage() throws IOException {
        BufferedImage bufferedImage = null;
        int n = ((PDFObject.PDFInteger)this.get("Width")).getValue();
        int n2 = ((PDFObject.PDFInteger)this.get("Height")).getValue();
        switch (this.imageType) {
            case 10: {
                bufferedImage = new BufferedImage(n, n2, 10);
                this.decodeJPEGGray(bufferedImage, this.data);
                break;
            }
            case 1: {
                bufferedImage = new BufferedImage(n, n2, 1);
                this.decodeJPEGRGB(bufferedImage, this.data);
                break;
            }
            case 12: {
                bufferedImage = new BufferedImage(n, n2, 12);
                this.decodeT6(bufferedImage, this.data);
            }
        }
        return bufferedImage;
    }

    private void decodeJPEGGray(BufferedImage bufferedImage, InputStream inputStream) throws IOException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        new JFIFInputStream(inputStream).read(byArray);
    }

    private void decodeJPEGRGB(BufferedImage bufferedImage, InputStream inputStream) throws IOException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        new JFIFInputStream(inputStream).read(nArray);
    }

    private void decodeT6(BufferedImage bufferedImage, InputStream inputStream) throws IOException {
        block7: {
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            int n = bufferedImage.getWidth();
            BitSwapInputStream bitSwapInputStream = new BitSwapInputStream(inputStream);
            ModModREADInputStream modModREADInputStream = new ModModREADInputStream((InputStream)bitSwapInputStream, n);
            RLEBitInputStream rLEBitInputStream = new RLEBitInputStream(modModREADInputStream);
            int n2 = 0;
            if ((n & 7) == 0) {
                byte[] byArray2 = new byte[n >> 3];
                int n3 = 0;
                while (true) {
                    rLEBitInputStream.resetToStartCodeWord();
                    ((ModHuffmanInputStream)modModREADInputStream).readEOL();
                    try {
                        n3 = rLEBitInputStream.read(byArray2);
                        if (n3 == -1) break block7;
                        System.arraycopy(byArray2, 0, byArray, n2, n3);
                    }
                    catch (ModHuffmanInputStream.ModHuffmanCodingException modHuffmanCodingException) {
                        System.out.println(this.getClass().getName() + ".copyin:\n\t" + modHuffmanCodingException);
                    }
                    n2 += n3;
                }
            }
            byte[] byArray3 = new byte[n + 7 >> 3];
            int n4 = 0;
            int n5 = 8 - (n & 7);
            while (true) {
                rLEBitInputStream.resetToStartCodeWord();
                ((ModHuffmanInputStream)modModREADInputStream).readEOL();
                try {
                    n4 = rLEBitInputStream.read(byArray3, 0, byArray3.length - 1);
                    if (n4 == -1) break;
                    int n6 = rLEBitInputStream.readBits(7, n5);
                    byArray3[n4] = (byte)n6;
                    System.arraycopy(byArray3, 0, byArray, n2, n4 + 1);
                }
                catch (ModHuffmanInputStream.ModHuffmanCodingException modHuffmanCodingException) {
                    System.out.println(this.getClass().getName() + ".copyin:\n\t" + modHuffmanCodingException);
                }
                n2 += n4 + 1;
            }
        }
    }
}

