/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.pdf.PDFArray;
import uk.co.mmscomputing.imageio.pdf.PDFDictionary;
import uk.co.mmscomputing.imageio.pdf.PDFObject;
import uk.co.mmscomputing.io.ModModREADOutputStream;
import uk.co.mmscomputing.io.RLEBit1OutputStream;

public class PDFFilter {
    private static PDFEncoder getEncoder(OutputStream outputStream, PDFDictionary pDFDictionary, String string) throws IOException {
        if (string.equals("ASCIIHexDecode")) {
            return new PDFASCIIHexEncoder(outputStream);
        }
        if (string.equals("ASCII85Decode")) {
            return new PDFASCII85Encoder(outputStream);
        }
        if (string.equals("DCTDecode")) {
            return new PDFEncoder(outputStream);
        }
        if (string.equals("CCITTFaxDecode")) {
            int n = ((PDFObject.PDFInteger)pDFDictionary.get("Width")).getValue();
            return new PDFEncoder(outputStream);
        }
        throw new IllegalArgumentException();
    }

    private static PDFEncoder getEncoder(OutputStream outputStream, PDFDictionary pDFDictionary, PDFArray pDFArray, int n) throws IOException {
        PDFObject.PDFName pDFName = (PDFObject.PDFName)pDFArray.elementAt(n);
        String string = pDFName.getName();
        PDFEncoder pDFEncoder = PDFFilter.getEncoder(outputStream, pDFDictionary, string);
        try {
            return PDFFilter.getEncoder(pDFEncoder, pDFDictionary, pDFArray, n + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return pDFEncoder;
        }
    }

    static PDFEncoder getEncoder(OutputStream outputStream, PDFDictionary pDFDictionary, PDFObject pDFObject) throws IOException {
        if (pDFObject instanceof PDFArray) {
            return PDFFilter.getEncoder(outputStream, pDFDictionary, (PDFArray)pDFObject, 0);
        }
        if (pDFObject instanceof PDFObject.PDFName) {
            return PDFFilter.getEncoder(outputStream, pDFDictionary, ((PDFObject.PDFName)pDFObject).getName());
        }
        throw new IllegalArgumentException();
    }

    public static void main(String[] stringArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PDFASCII85Encoder pDFASCII85Encoder = new PDFASCII85Encoder(byteArrayOutputStream);
            byte[] byArray = new byte[]{-1, -40, -1, -32, 0, 16, -92, 70, 73, 70};
            pDFASCII85Encoder.write(byArray);
            pDFASCII85Encoder.close();
            System.err.println(new String(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class PDFCCITTFaxEncoder
    extends PDFEncoder {
        RLEBit1OutputStream rlos;
        ModModREADOutputStream mmros;
        int offLine;
        int bytesPerLine;

        public PDFCCITTFaxEncoder(OutputStream outputStream, int n) throws IOException {
            super(outputStream);
            this.bytesPerLine = n + 7 >> 3;
            this.mmros = new ModModREADOutputStream(outputStream, n);
            this.rlos = new RLEBit1OutputStream(this.mmros);
            outputStream = this.rlos;
            this.rlos.setStartCodeWord(1);
            this.mmros.writeEOL();
            this.offLine = 0;
        }

        public void write(int n) throws IOException {
            if (this.offLine == this.bytesPerLine) {
                this.rlos.setStartCodeWord(1);
                this.mmros.writeEOL();
                this.offLine = 0;
            }
            super.write(n);
            ++this.offLine;
        }

        public void close() throws IOException {
            this.rlos.flush();
            this.mmros.writeEOFB();
            this.mmros.flush();
            super.close();
        }
    }

    public static class PDFASCII85Encoder
    extends PDFLineEncoder {
        int i = 0;
        long val = 0L;

        public PDFASCII85Encoder(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(int n) throws IOException {
            this.val <<= 8;
            this.val |= (long)(n & 0xFF);
            ++this.i;
            if (this.i == 4) {
                if (this.val == 0L) {
                    super.write(122);
                } else {
                    int n2 = 52200625;
                    for (int i = 0; i < 5; ++i) {
                        super.write(33 + (int)(this.val / (long)n2));
                        this.val %= (long)n2;
                        n2 /= 85;
                    }
                }
                this.i = 0;
                this.val = 0L;
            }
        }

        public void close() throws IOException {
            if (this.i > 0) {
                int n;
                for (n = this.i; n < 4; ++n) {
                    this.val <<= 8;
                }
                n = 52200625;
                for (int i = 0; i < this.i + 1; ++i) {
                    super.write(33 + (int)(this.val / (long)n));
                    this.val %= (long)n;
                    n /= 85;
                }
            }
            super.write(126);
            super.write(62);
            super.close();
        }
    }

    public static class PDFASCIIHexEncoder
    extends PDFLineEncoder {
        public PDFASCIIHexEncoder(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(int n) throws IOException {
            int n2 = n >> 4 & 0xF;
            int n3 = n & 0xF;
            n2 = n2 < 10 ? 48 + n2 : 65 + (n2 - 10);
            n3 = n3 < 10 ? 48 + n3 : 65 + (n3 - 10);
            super.write(n2);
            super.write(n3);
        }

        public void close() throws IOException {
            super.write(62);
            super.close();
        }
    }

    public static class PDFLineEncoder
    extends PDFEncoder {
        public PDFLineEncoder(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(int n) throws IOException {
            if (this.len % 255 == 254) {
                super.write(10);
            }
            super.write(n);
        }
    }

    public static class PDFEncoder
    extends FilterOutputStream {
        protected int len = 0;

        public PDFEncoder(OutputStream outputStream) {
            super(outputStream);
        }

        public int getLength() {
            return this.len;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            for (int i = n; i < n + n2; ++i) {
                this.write(byArray[i]);
            }
        }

        public void write(int n) throws IOException {
            super.write(n);
            ++this.len;
        }
    }
}

