/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import uk.co.mmscomputing.imageio.pdf.PDFFile;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectObject;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectReference;
import uk.co.mmscomputing.imageio.pdf.PDFObject;
import uk.co.mmscomputing.imageio.pdf.PDFScanner;

public class PDFDictionary
extends PDFObject {
    private Vector list = new Vector();

    public void put(String string, PDFObject pDFObject) {
        if (pDFObject instanceof PDFIndirectObject) {
            pDFObject = new PDFIndirectReference((PDFIndirectObject)pDFObject);
        }
        Enumeration enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            PDFDictionaryEntry pDFDictionaryEntry = (PDFDictionaryEntry)enumeration.nextElement();
            if (!string.equals(pDFDictionaryEntry.getKey())) continue;
            pDFDictionaryEntry.obj = pDFObject;
            return;
        }
        this.list.add(new PDFDictionaryEntry(string, pDFObject));
    }

    public PDFObject get(String string) {
        Enumeration enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            PDFDictionaryEntry pDFDictionaryEntry = (PDFDictionaryEntry)enumeration.nextElement();
            if (!string.equals(pDFDictionaryEntry.getKey())) continue;
            return pDFDictionaryEntry.getValue();
        }
        return null;
    }

    public PDFObject getObject(String string) {
        PDFObject pDFObject = this.get(string);
        while (pDFObject instanceof PDFIndirectReference) {
            pDFObject = ((PDFIndirectReference)pDFObject).getIndirectObject().getDirectObject();
        }
        return pDFObject;
    }

    public boolean checkNameEntry(String string, String string2) {
        PDFObject pDFObject = this.get(string);
        if (pDFObject == null) {
            return false;
        }
        if (!(pDFObject instanceof PDFObject.PDFName)) {
            return false;
        }
        return ((PDFObject.PDFName)pDFObject).getName().equals(string2);
    }

    public void read(PDFScanner pDFScanner) throws IOException {
        if (pDFScanner.symbol == 304) {
            pDFScanner.scan();
            while (pDFScanner.symbol != 305) {
                PDFObject pDFObject = PDFDictionary.readObject(pDFScanner);
                if (!(pDFObject instanceof PDFObject.PDFName)) {
                    throw new IOException(this.getClass().getName() + ".read\n\tDictionary key must be of type NAME.\nSYMBOL = " + pDFScanner.symbol + " " + pDFObject);
                }
                PDFObject pDFObject2 = PDFDictionary.readObject(pDFScanner);
                if (pDFObject2 == null) {
                    throw new IOException(this.getClass().getName() + ".read\n\tDictionary obj is missing.");
                }
                this.put(((PDFObject.PDFName)pDFObject).getName(), pDFObject2);
            }
            if (pDFScanner.symbol != 305) {
                throw new IOException(this.getClass().getName() + ".read\n\tDictionary: Missing start >> .");
            }
        } else {
            throw new IOException(this.getClass().getName() + ".read\n\tDictionary: Missing start << .");
        }
    }

    public void write(PDFFile pDFFile) throws IOException {
        pDFFile.writeln("<<");
        Enumeration enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            ((PDFDictionaryEntry)enumeration.nextElement()).write(pDFFile);
        }
        pDFFile.writeln(">>");
    }

    public String toString() {
        String string = "<<\n";
        Enumeration enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            string = string + enumeration.nextElement();
        }
        string = string + ">>\n";
        return string;
    }

    public static class PDFDictionaryEntry {
        private PDFObject.PDFName key;
        private PDFObject obj;

        public PDFDictionaryEntry(String string, PDFObject pDFObject) {
            this.key = new PDFObject.PDFName(string);
            this.obj = pDFObject;
        }

        public String getKey() {
            return this.key.getName();
        }

        public PDFObject getValue() {
            return this.obj;
        }

        public void write(PDFFile pDFFile) throws IOException {
            this.key.write(pDFFile);
            this.obj.write(pDFFile);
            if (!(this.obj instanceof PDFDictionary)) {
                pDFFile.write("\n");
            }
        }

        public String toString() {
            return this.key.toString() + this.obj.toString() + (this.obj instanceof PDFDictionary ? "" : "\n");
        }
    }
}

