/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import uk.co.mmscomputing.imageio.pdf.PDFFile;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectObject;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectReference;
import uk.co.mmscomputing.imageio.pdf.PDFObject;
import uk.co.mmscomputing.imageio.pdf.PDFScanner;

public class PDFArray
extends PDFObject {
    private Vector value = new Vector();

    public void setValue(Vector vector) {
        this.value = vector;
    }

    public Vector getValue() {
        return this.value;
    }

    public int size() {
        return this.value.size();
    }

    public void add(PDFObject pDFObject) {
        if (pDFObject instanceof PDFIndirectObject) {
            pDFObject = new PDFIndirectReference((PDFIndirectObject)pDFObject);
        }
        this.value.add(pDFObject);
    }

    public PDFObject elementAt(int n) {
        return (PDFObject)this.value.elementAt(n);
    }

    public void read(PDFScanner pDFScanner) throws IOException {
        pDFScanner.scan();
        while (pDFScanner.symbol != 303) {
            this.add(PDFArray.readObject(pDFScanner));
        }
    }

    public void write(PDFFile pDFFile) throws IOException {
        pDFFile.write('[');
        Enumeration enumeration = this.value.elements();
        while (enumeration.hasMoreElements()) {
            ((PDFObject)enumeration.nextElement()).write(pDFFile);
        }
        pDFFile.write(']');
    }

    public String toString() {
        String string = "[";
        Enumeration enumeration = this.value.elements();
        while (enumeration.hasMoreElements()) {
            string = string + ((PDFObject)enumeration.nextElement()).toString();
        }
        string = string + "]";
        return string;
    }
}

