/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGBitOutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGComponentsOutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGConstants;
import uk.co.mmscomputing.imageio.jpeg.JPEGDCTOutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGHuffmanOutputStream;

public class JPEGOutputStream
extends OutputStream
implements JPEGConstants {
    private int spp = 0;
    private int qtprecision = 0;
    private JPEGBitOutputStream out;
    private JPEGDCTOutputStream[] dcts;
    private JPEGComponentsOutputStream cout;
    protected int[][] qts = new int[4][];
    protected JPEGHuffmanOutputStream[] dcouts = new JPEGHuffmanOutputStream[4];
    protected JPEGHuffmanOutputStream[] acouts = new JPEGHuffmanOutputStream[4];

    public JPEGOutputStream(OutputStream outputStream) throws IOException {
        this.out = new JPEGBitOutputStream(outputStream);
        this.startOfImage();
    }

    public void setZZQuantizationTable(int n, int[] nArray) {
        this.qts[n] = nArray;
    }

    public void setZZQuantizationTable(int n, int[] nArray, int n2) {
        int[] nArray2;
        if (0 < n2 && n2 <= 100) {
            nArray2 = new int[64];
            System.arraycopy(nArray, 0, nArray2, 0, 64);
            for (int i = 0; i < 64; ++i) {
                nArray2[i] = nArray2[i] * 25 / n2;
            }
        } else {
            throw new IllegalArgumentException(this.getClass().getName() + ".setZZQuantizationTable:\n\tParameter quality out of range [" + n2 + "]");
        }
        this.setZZQuantizationTable(n, nArray2);
    }

    public void setRawDCHuffmanTable(int n, byte[] byArray) throws IOException {
        this.dcouts[n] = new JPEGHuffmanOutputStream(this.out, new ByteArrayInputStream(byArray));
    }

    public void setRawACHuffmanTable(int n, byte[] byArray) throws IOException {
        this.acouts[n] = new JPEGHuffmanOutputStream(this.out, new ByteArrayInputStream(byArray));
    }

    public void startOfFrame(int n, int n2, int[] nArray, int[] nArray2) throws IOException {
        this.out.write(255);
        this.out.write(192);
        this.spp = nArray.length;
        int n3 = 8 + this.spp * 3;
        this.out.write(n3 >> 8 & 0xFF);
        this.out.write(n3 & 0xFF);
        this.out.write(8);
        this.out.write(n >> 8 & 0xFF);
        this.out.write(n & 0xFF);
        this.out.write(n2 >> 8 & 0xFF);
        this.out.write(n2 & 0xFF);
        this.out.write(this.spp);
        this.dcts = new JPEGDCTOutputStream[this.spp];
        for (int i = 0; i < this.spp; ++i) {
            this.out.write(i + 1);
            this.out.write(nArray[i]);
            this.out.write(nArray2[i]);
            this.dcts[i] = new JPEGDCTOutputStream(this.qts[nArray2[i]]);
        }
        this.cout = new JPEGComponentsOutputStream(this.dcts, nArray, n2);
    }

    public void defineHuffmanTables() throws IOException {
        int n;
        this.out.write(255);
        this.out.write(196);
        int n2 = 2;
        for (n = 0; n < this.dcouts.length; ++n) {
            if (this.dcouts[n] != null) {
                n2 += this.dcouts[n].getTableDataLength() + 1;
            }
            if (this.acouts[n] == null) continue;
            n2 += this.acouts[n].getTableDataLength() + 1;
        }
        this.out.write(n2 >> 8 & 0xFF);
        this.out.write(n2 & 0xFF);
        for (n = 0; n < this.dcouts.length; ++n) {
            if (this.dcouts[n] == null) continue;
            this.out.write(n);
            this.dcouts[n].writeTableData(this.out);
        }
        for (n = 0; n < this.acouts.length; ++n) {
            if (this.acouts[n] == null) continue;
            this.out.write(0x10 | n);
            this.acouts[n].writeTableData(this.out);
        }
    }

    public void startOfImage() throws IOException {
        this.out.write(255);
        this.out.write(216);
    }

    public void endOfImage() throws IOException {
        this.out.write(255);
        this.out.write(217);
    }

    public void defineQuantizationTables() throws IOException {
        this.out.write(255);
        this.out.write(219);
        int n = 2;
        for (int i = 0; i < this.qts.length; ++i) {
            if (this.qts[i] == null) continue;
            n += 65;
        }
        this.out.write(n >> 8 & 0xFF);
        this.out.write(n & 0xFF);
        for (int i = 0; i < this.qts.length; ++i) {
            int[] nArray = this.qts[i];
            if (nArray == null) continue;
            this.out.write(this.qtprecision << 4 | i);
            for (int j = 0; j < 64; ++j) {
                this.out.write(nArray[j]);
            }
        }
    }

    public void startOfScan(int[] nArray) throws IOException {
        this.out.write(255);
        this.out.write(218);
        this.spp = nArray.length;
        int n = 6 + this.spp * 2;
        this.out.write(n >> 8 & 0xFF);
        this.out.write(n & 0xFF);
        this.out.write(this.spp);
        for (int i = 0; i < this.spp; ++i) {
            this.out.write(i + 1);
            this.out.write(nArray[i]);
            int n2 = nArray[i] >> 4 & 0xF;
            int n3 = nArray[i] & 0xF;
            this.dcts[i].setHuffmanOutputStreams(this.dcouts[n2], this.acouts[n3]);
        }
        this.out.write(0);
        this.out.write(63);
        this.out.write(0);
    }

    public void write(int n) throws IOException {
        this.cout.write(n);
    }

    public void flush() throws IOException {
        if (this.cout != null) {
            this.cout.flush();
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.endOfImage();
        this.out.close();
    }
}

