/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGBitInputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGComponentInputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGConstants;
import uk.co.mmscomputing.imageio.jpeg.JPEGFastDCTInputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGHuffmanInputStream;
import uk.co.mmscomputing.io.IntFilterInputStream;

public class JPEGInputStream
extends IntFilterInputStream
implements JPEGConstants {
    JPEGBitInputStream in;
    protected int bps;
    protected int height;
    protected int width;
    protected int maxHor = 0;
    protected int maxVert = 0;
    protected int mcuHeight;
    protected int mcuWidth;
    protected int mcuRows;
    protected int mcuCols;
    protected int spp;
    private int[][] qts = new int[4][];
    protected JPEGHuffmanInputStream[] dcins = new JPEGHuffmanInputStream[4];
    protected JPEGHuffmanInputStream[] acins = new JPEGHuffmanInputStream[4];
    private int[] cqts = new int[]{-1, -1, -1, -1};
    protected JPEGComponentInputStream[] compins = new JPEGComponentInputStream[4];
    protected JPEGComponentInputStream[] scanins = new JPEGComponentInputStream[4];
    protected int Ri = 0;

    public JPEGInputStream(InputStream inputStream) throws IOException {
        super(null);
        this.in = new JPEGBitInputStream(inputStream, this);
        this.in.start();
    }

    public JPEGInputStream(InputStream inputStream, int[][] nArray, JPEGHuffmanInputStream[] jPEGHuffmanInputStreamArray, JPEGHuffmanInputStream[] jPEGHuffmanInputStreamArray2) throws IOException {
        super(null);
        int n;
        this.qts = nArray;
        this.dcins = jPEGHuffmanInputStreamArray;
        this.acins = jPEGHuffmanInputStreamArray2;
        this.in = new JPEGBitInputStream(inputStream, this);
        this.in.start();
        for (n = 0; jPEGHuffmanInputStreamArray[n] != null && n < jPEGHuffmanInputStreamArray.length; ++n) {
            jPEGHuffmanInputStreamArray[n].setInputStream(this.in);
        }
        for (n = 0; jPEGHuffmanInputStreamArray2[n] != null && n < jPEGHuffmanInputStreamArray2.length; ++n) {
            jPEGHuffmanInputStreamArray2[n].setInputStream(this.in);
        }
    }

    public int[][] getQTs() {
        return this.qts;
    }

    public JPEGHuffmanInputStream[] getDCIns() {
        return this.dcins;
    }

    public JPEGHuffmanInputStream[] getACIns() {
        return this.acins;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getNumComponents() {
        return this.spp;
    }

    protected int readIn(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            IOException iOException = new IOException(this.getClass().getName() + "readIn:\n\tUnexpected end of file.");
            iOException.printStackTrace();
            throw iOException;
        }
        return n;
    }

    public void startOfFrame(InputStream inputStream, int n) throws IOException {
        this.bps = this.readIn(inputStream);
        this.height = this.readIn(inputStream) << 8 | this.readIn(inputStream);
        this.width = this.readIn(inputStream) << 8 | this.readIn(inputStream);
        this.spp = this.readIn(inputStream);
        if (this.qts[0] == null) {
            this.initQuantizationTables();
        }
        int n2 = 0;
        while (n2 < this.spp) {
            int n3 = this.readIn(inputStream);
            this.compins[n2] = new JPEGComponentInputStream(n3);
            this.compins[n2].setBitsPerSample(this.bps);
            this.compins[n2].setDimensions(this.height, this.width);
            int n4 = this.readIn(inputStream);
            int n5 = n4 >> 4 & 0xF;
            int n6 = n4 & 0xF;
            if (this.spp == 1) {
                this.maxHor = 1;
                this.maxVert = 1;
                this.compins[n2].setSamplingRate(1, 1);
            } else {
                if (n5 > this.maxHor) {
                    this.maxHor = n5;
                }
                if (n6 > this.maxVert) {
                    this.maxVert = n6;
                }
                this.compins[n2].setSamplingRate(n6, n5);
            }
            int n7 = this.readIn(inputStream);
            this.compins[n2].setQuantizationTable(this.qts[n7]);
            this.cqts[n7] = n2++;
        }
        for (n2 = 0; n2 < this.spp; ++n2) {
            this.compins[n2].setMaxSamplingRate(this.maxVert, this.maxHor);
        }
        this.mcuHeight = this.maxVert * 8;
        this.mcuWidth = this.maxHor * 8;
        this.mcuRows = (this.height + this.mcuHeight - 1) / this.mcuHeight;
        this.mcuCols = (this.width + this.mcuWidth - 1) / this.mcuWidth;
    }

    public void defineHuffmanTables(InputStream inputStream) throws IOException {
        block4: for (int i = 0; i < 8; ++i) {
            int n = inputStream.read();
            switch (n >> 4 & 0xF) {
                case 0: {
                    this.dcins[n & 0xF] = new JPEGHuffmanInputStream(this.in, inputStream);
                    continue block4;
                }
                case 1: {
                    this.acins[n & 0xF] = new JPEGHuffmanInputStream(this.in, inputStream);
                    continue block4;
                }
                default: {
                    return;
                }
            }
        }
    }

    public void defineArithmeticConditioning(InputStream inputStream) throws IOException {
        System.out.println("3\bDefine Arithmetic Conditioning");
    }

    public void restartIntervalTermination(int n) throws IOException {
        for (int i = 0; i < this.spp; ++i) {
            this.scanins[i].restart();
        }
    }

    public void startOfImage() {
    }

    public void endOfImage() {
    }

    public void startOfScan(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        this.spp = this.readIn(inputStream);
        block6: for (n3 = 0; n3 < this.spp; ++n3) {
            n2 = this.readIn(inputStream);
            for (n = 0; this.compins[n] != null && n < 4; ++n) {
                if (this.compins[n].getId() != n2) continue;
                this.scanins[n3] = this.compins[n];
                break;
            }
            n = this.readIn(inputStream);
            this.scanins[n3].setHuffmanTables(this.dcins[n >> 4 & 0xF], this.acins[n & 0xF]);
            switch (n3) {
                case 0: {
                    this.scanins[n3].setShift(16);
                    continue block6;
                }
                case 1: {
                    this.scanins[n3].setShift(8);
                    continue block6;
                }
                case 2: {
                    this.scanins[n3].setShift(0);
                    continue block6;
                }
                case 3: {
                    this.scanins[n3].setShift(24);
                }
            }
        }
        n3 = this.readIn(inputStream);
        n2 = this.readIn(inputStream);
        n = this.readIn(inputStream);
        int n4 = n >> 4 & 0xF;
        int n5 = n & 0xF;
    }

    private void initQuantizationTables() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(0);
        int[] nArray = JPEGConstants.LQT2;
        for (n = 0; n < nArray.length; ++n) {
            byteArrayOutputStream.write(nArray[n]);
        }
        byteArrayOutputStream.write(1);
        nArray = JPEGConstants.CQT2;
        for (n = 0; n < nArray.length; ++n) {
            byteArrayOutputStream.write(nArray[n]);
        }
        byteArrayOutputStream.write(2);
        for (n = 0; n < nArray.length; ++n) {
            byteArrayOutputStream.write(nArray[n]);
        }
        byteArrayOutputStream.write(3);
        for (n = 0; n < nArray.length; ++n) {
            byteArrayOutputStream.write(nArray[n]);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        this.defineQuantizationTables(byteArrayInputStream);
    }

    public void defineQuantizationTables(InputStream inputStream) throws IOException {
        for (int i = 0; i < 4; ++i) {
            int[] nArray;
            int n = inputStream.read();
            int n2 = n >> 4 & 0xF;
            int n3 = n & 0xF;
            switch (n2) {
                case 0: {
                    int n4;
                    nArray = new int[64];
                    for (n4 = 0; n4 < 64; ++n4) {
                        nArray[n4] = this.readIn(inputStream);
                    }
                    break;
                }
                case 1: {
                    int n4;
                    nArray = new int[64];
                    for (n4 = 0; n4 < 64; ++n4) {
                        nArray[n4] = this.readIn(inputStream) << 8 | this.readIn(inputStream);
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            JPEGFastDCTInputStream.normalize(nArray);
            this.qts[n3] = nArray;
            if (this.cqts[i] == -1) continue;
            this.compins[this.cqts[i]].setQuantizationTable(nArray);
        }
    }

    public void defineNumberOfLines(InputStream inputStream) throws IOException {
        this.height = this.readIn(inputStream) << 8 | this.readIn(inputStream);
        System.out.println("3\bDefine Number of Lines: height=" + this.height);
    }

    public void defineRestartInterval(InputStream inputStream) throws IOException {
        this.Ri = this.readIn(inputStream) << 8 | this.readIn(inputStream);
    }

    public void defineHierarchicalProgression(InputStream inputStream) throws IOException {
        throw new IOException(this.getClass().getName() + "defineHierarchicalProgression:\n\tDo not support 'Hierarchical Progression' mode.");
    }

    public void expandReferenceComponents(InputStream inputStream) throws IOException {
        throw new IOException(this.getClass().getName() + "defineHierarchicalProgression:\n\tDo not support 'expand reference component(s)'.");
    }

    protected void dump(InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        while ((n = inputStream.read()) != -1) {
            System.out.println("appl[" + n2 + "] 0x" + Integer.toHexString(n) + " " + (char)(n >= 32 ? n : 32) + " " + n);
            ++n2;
        }
    }

    public void app0(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app1(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app2(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app3(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app4(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app5(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app6(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app7(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app8(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app9(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app10(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app11(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app12(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app13(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app14(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void app15(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public void comment(InputStream inputStream) throws IOException {
        this.dump(inputStream);
    }

    public int read() throws IOException {
        throw new IOException(this.getClass().getName() + ".read():\nInternal Error: Don't support simple read().");
    }

    public int read(int[] nArray, int n, int n2) throws IOException {
        int n3 = 0;
        for (int i = 0; i < this.mcuRows; ++i) {
            int n4 = 0;
            for (int j = 0; j < this.mcuCols; ++j) {
                for (int k = 0; k < this.spp; ++k) {
                    this.scanins[k].read(nArray, n + n3 * this.width + n4, this.mcuHeight < this.height - n3 ? this.mcuHeight : this.height - n3, this.mcuWidth < this.width - n4 ? this.mcuWidth : this.width - n4);
                }
                n4 += this.mcuWidth;
            }
            n3 += this.mcuHeight;
        }
        return n2;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        for (int i = 0; i < this.mcuRows; ++i) {
            int n4 = 0;
            for (int j = 0; j < this.mcuCols; ++j) {
                this.scanins[0].read(byArray, n + n3 * this.width + n4, this.mcuHeight < this.height - n3 ? this.mcuHeight : this.height - n3, this.mcuWidth < this.width - n4 ? this.mcuWidth : this.width - n4);
                n4 += this.mcuWidth;
            }
            n3 += this.mcuHeight;
        }
        return n2;
    }
}

