/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGBitOutputStream;

public class JPEGHuffmanOutputStream
extends OutputStream {
    protected int[] BITS = new int[16];
    protected int[] HUFFVAL;
    protected int[] HUFFSIZE;
    protected int[] HUFFCODE;
    protected int[] EHUFSI;
    protected int[] EHUFCO;
    protected int[] VALPTR = new int[16];
    protected int[] MINCODE = new int[16];
    protected int[] MAXCODE = new int[16];
    protected JPEGBitOutputStream out;

    public JPEGHuffmanOutputStream(JPEGBitOutputStream jPEGBitOutputStream, InputStream inputStream) throws IOException {
        this.out = jPEGBitOutputStream;
        this.initialize(inputStream);
    }

    private void initialize(InputStream inputStream) throws IOException {
        int n = this.readTableData(inputStream);
        this.generateSizeTable(n);
        this.generateCodeTable(n);
        this.orderCodes(n);
    }

    private int readTableData(InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        for (n = 0; n < 16; ++n) {
            this.BITS[n] = inputStream.read();
            n2 += this.BITS[n];
        }
        this.HUFFVAL = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.HUFFVAL[n] = inputStream.read();
        }
        return n2;
    }

    private void generateSizeTable(int n) {
        this.HUFFSIZE = new int[n + 1];
        int n2 = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < this.BITS[i]; ++j) {
                this.HUFFSIZE[n2++] = i + 1;
            }
        }
        this.HUFFSIZE[n2] = 0;
    }

    private void generateCodeTable(int n) {
        this.HUFFCODE = new int[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = this.HUFFSIZE[0];
        while (true) {
            this.HUFFCODE[n2] = n3++;
            if (this.HUFFSIZE[++n2] == n4) continue;
            if (this.HUFFSIZE[n2] == 0) break;
            do {
                n3 <<= 1;
            } while (this.HUFFSIZE[n2] != ++n4);
        }
    }

    private void orderCodes(int n) {
        this.EHUFCO = new int[256];
        this.EHUFSI = new int[256];
        for (int i = 0; i < n; ++i) {
            int n2 = this.HUFFVAL[i];
            this.EHUFCO[n2] = this.HUFFCODE[i];
            this.EHUFSI[n2] = this.HUFFSIZE[i];
        }
    }

    public int getTableDataLength() {
        return this.BITS.length + this.HUFFVAL.length;
    }

    public void writeTableData(OutputStream outputStream) throws IOException {
        int n;
        for (n = 0; n < this.BITS.length; ++n) {
            outputStream.write(this.BITS[n]);
        }
        for (n = 0; n < this.HUFFVAL.length; ++n) {
            outputStream.write(this.HUFFVAL[n]);
        }
    }

    public void write(int n) throws IOException {
        this.out.writeBits(this.EHUFCO[n], this.EHUFSI[n]);
    }

    public void writeBits(int n, int n2) throws IOException {
        this.out.writeBits(n, n2);
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

