/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGBitInputStream;

public class JPEGHuffmanInputStream
extends InputStream {
    protected int[] BITS = new int[16];
    protected int[] HUFFVAL;
    protected int[] HUFFSIZE;
    protected int[] HUFFCODE;
    protected int[] VALPTR = new int[16];
    protected int[] MINCODE = new int[16];
    protected int[] MAXCODE = new int[16];
    protected JPEGBitInputStream in;
    private int code;
    private int index;

    public JPEGHuffmanInputStream(JPEGBitInputStream jPEGBitInputStream, InputStream inputStream) throws IOException {
        this.in = jPEGBitInputStream;
        this.initialize(inputStream);
    }

    public JPEGHuffmanInputStream(InputStream inputStream) throws IOException {
        this.in = null;
        this.initialize(inputStream);
    }

    public void setInputStream(JPEGBitInputStream jPEGBitInputStream) throws IOException {
        this.in = jPEGBitInputStream;
    }

    private void initialize(InputStream inputStream) throws IOException {
        int n = this.readTableData(inputStream);
        this.generateSizeTable(n);
        this.generateCodeTable(n);
        this.generateDecoderTable();
    }

    private int readTableData(InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        for (n = 0; n < 16; ++n) {
            this.BITS[n] = inputStream.read();
            n2 += this.BITS[n];
        }
        this.HUFFVAL = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.HUFFVAL[n] = inputStream.read();
        }
        return n2;
    }

    private void generateSizeTable(int n) {
        this.HUFFSIZE = new int[n + 1];
        int n2 = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < this.BITS[i]; ++j) {
                this.HUFFSIZE[n2++] = i + 1;
            }
        }
        this.HUFFSIZE[n2] = 0;
    }

    private void generateCodeTable(int n) {
        this.HUFFCODE = new int[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = this.HUFFSIZE[0];
        while (true) {
            this.HUFFCODE[n2] = n3++;
            if (this.HUFFSIZE[++n2] == n4) continue;
            if (this.HUFFSIZE[n2] == 0) break;
            do {
                n3 <<= 1;
            } while (this.HUFFSIZE[n2] != ++n4);
        }
    }

    private void generateDecoderTable() {
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            if (this.BITS[i] == 0) {
                this.MAXCODE[i] = -1;
                continue;
            }
            this.VALPTR[i] = n;
            this.MINCODE[i] = this.HUFFCODE[n];
            this.MAXCODE[i] = this.HUFFCODE[n += this.BITS[i] - 1];
            ++n;
        }
    }

    public String toString() {
        int n;
        String string = "\n" + this.getClass().getName() + "\n";
        string = string + "byte[] BITS={";
        for (n = 0; n < this.BITS.length; ++n) {
            string = string + Integer.toString(this.BITS[n] < 128 ? this.BITS[n] : this.BITS[n] - 256) + ",";
        }
        string = string + "};\n";
        string = string + "byte[] HUFFVAL={";
        for (n = 0; n < this.HUFFVAL.length; ++n) {
            string = string + Integer.toString(this.HUFFVAL[n] < 128 ? this.HUFFVAL[n] : this.HUFFVAL[n] - 256) + ",";
        }
        string = string + "};\n";
        return string;
    }

    public int readBits(int n) throws IOException {
        int n2;
        int n3 = this.in.readBits(n);
        if (n3 < (n2 = 1 << n - 1)) {
            n2 = (-1 << n) + 1;
            n3 += n2;
        }
        return n3;
    }

    public void restart() throws IOException {
        this.code = 0;
        this.index = 0;
    }

    public int read() throws IOException {
        this.index = 0;
        this.code = this.in.readBit();
        if (this.code == -1) {
            return -1;
        }
        while (this.code > this.MAXCODE[this.index++]) {
            int n = this.in.readBit();
            if (n == -1) {
                return -1;
            }
            this.code = this.code << 1 | n;
        }
        int n = this.VALPTR[--this.index];
        return this.HUFFVAL[n += this.code - this.MINCODE[this.index]];
    }
}

