/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGACOutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGConstants;
import uk.co.mmscomputing.imageio.jpeg.JPEGDCOutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGHuffmanOutputStream;

public class JPEGDCTOutputStream
extends OutputStream
implements JPEGConstants {
    private static final int levelshift = 128;
    protected int count;
    protected float[] buffer = new float[64];
    protected int[] qt;
    protected OutputStream dc;
    protected OutputStream ac;
    private static final float F0 = (float)(1.0 / Math.sqrt(2.0));
    private static final float F1 = (float)Math.cos(0.19634954084936207) / 2.0f;
    private static final float F2 = (float)Math.cos(0.39269908169872414) / 2.0f;
    private static final float F3 = (float)Math.cos(0.5890486225480862) / 2.0f;
    private static final float F4 = (float)Math.cos(0.7853981633974483) / 2.0f;
    private static final float F5 = (float)Math.cos(0.9817477042468103) / 2.0f;
    private static final float F6 = (float)Math.cos(1.1780972450961724) / 2.0f;
    private static final float F7 = (float)Math.cos(1.3744467859455345) / 2.0f;
    private static final float D71 = F7 - F1;
    private static final float D35 = F3 - F5;
    private static final float D62 = F6 - F2;
    private static final float S71 = F7 + F1;
    private static final float S35 = F3 + F5;
    private static final float S62 = F6 + F2;

    public JPEGDCTOutputStream(int[] nArray) throws IOException {
        this.qt = nArray;
        this.dc = null;
        this.ac = null;
        this.count = 0;
    }

    public void setHuffmanOutputStreams(JPEGHuffmanOutputStream jPEGHuffmanOutputStream, JPEGHuffmanOutputStream jPEGHuffmanOutputStream2) throws IOException {
        this.dc = new JPEGDCOutputStream(jPEGHuffmanOutputStream);
        this.ac = new JPEGACOutputStream(jPEGHuffmanOutputStream2);
    }

    public void write(int n) throws IOException {
        this.buffer[this.count++] = n - 128;
        if (this.count == 64) {
            this.forwardDCT(this.buffer);
            this.dc.write(Math.round(this.buffer[IZigZagTable[0]] / (float)this.qt[0]));
            for (int i = 1; i < 64; ++i) {
                this.ac.write(Math.round(this.buffer[IZigZagTable[i]] / (float)this.qt[i]));
            }
            this.count = 0;
        }
    }

    protected void forwardDCT(float[] fArray) throws IOException {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        int n;
        for (n = 0; n < 64; n += 8) {
            f17 = fArray[n + 0] + fArray[n + 7];
            f16 = fArray[n + 0] - fArray[n + 7];
            f15 = fArray[n + 1] + fArray[n + 6];
            f14 = fArray[n + 1] - fArray[n + 6];
            f13 = fArray[n + 2] + fArray[n + 5];
            f12 = fArray[n + 2] - fArray[n + 5];
            f11 = fArray[n + 3] + fArray[n + 4];
            f10 = fArray[n + 3] - fArray[n + 4];
            f9 = f17 + f11;
            f8 = f15 + f13;
            f7 = f15 - f13;
            f6 = f17 - f11;
            f5 = f10;
            f4 = (f14 - f12) * F0;
            f3 = (f14 + f12) * F0;
            f2 = f16;
            fArray[n + 0] = (f9 + f8) * F4;
            fArray[n + 4] = (f9 - f8) * F4;
            f = (f6 + f7) * F6;
            fArray[n + 2] = f - f6 * D62;
            fArray[n + 6] = f - f7 * S62;
            f10 = f5 + f4;
            f16 = f2 + f3;
            f12 = f5 - f4;
            f14 = f2 - f3;
            f = (f16 + f10) * F7;
            fArray[n + 1] = f - f16 * D71;
            fArray[n + 7] = f - f10 * S71;
            f = (f14 + f12) * F3;
            fArray[n + 5] = f - f14 * D35;
            fArray[n + 3] = f - f12 * S35;
        }
        for (n = 0; n < 8; ++n) {
            f17 = fArray[0 + n] + fArray[56 + n];
            f16 = fArray[0 + n] - fArray[56 + n];
            f15 = fArray[8 + n] + fArray[48 + n];
            f14 = fArray[8 + n] - fArray[48 + n];
            f13 = fArray[16 + n] + fArray[40 + n];
            f12 = fArray[16 + n] - fArray[40 + n];
            f11 = fArray[24 + n] + fArray[32 + n];
            f10 = fArray[24 + n] - fArray[32 + n];
            f9 = f17 + f11;
            f8 = f15 + f13;
            f7 = f15 - f13;
            f6 = f17 - f11;
            f5 = f10;
            f4 = (f14 - f12) * F0;
            f3 = (f14 + f12) * F0;
            f2 = f16;
            fArray[0 + n] = (f9 + f8) * F4;
            fArray[32 + n] = (f9 - f8) * F4;
            f = (f6 + f7) * F6;
            fArray[16 + n] = f - f6 * D62;
            fArray[48 + n] = f - f7 * S62;
            f10 = f5 + f4;
            f16 = f2 + f3;
            f12 = f5 - f4;
            f14 = f2 - f3;
            f = (f16 + f10) * F7;
            fArray[8 + n] = f - f16 * D71;
            fArray[56 + n] = f - f10 * S71;
            f = (f14 + f12) * F3;
            fArray[40 + n] = f - f14 * D35;
            fArray[24 + n] = f - f12 * S35;
        }
    }
}

