/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGDCTInputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGFastDCTInputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGHuffmanInputStream;

public class JPEGComponentInputStream
extends InputStream {
    protected int id;
    protected int shift = 0;
    protected int height;
    protected int width;
    protected int bps;
    protected int Hf;
    protected int Vf;
    protected int HMax;
    protected int VMax;
    protected int Yf;
    protected int Xf;
    protected int[] qt;
    protected JPEGDCTInputStream in;

    public JPEGComponentInputStream(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public void setShift(int n) {
        this.shift = n;
    }

    public void setBitsPerSample(int n) {
        this.bps = n;
    }

    public void setDimensions(int n, int n2) {
        this.height = n;
        this.width = n2;
    }

    public void setSamplingRate(int n, int n2) {
        this.Vf = n;
        this.Hf = n2;
    }

    public void setMaxSamplingRate(int n, int n2) {
        this.VMax = n;
        this.HMax = n2;
        this.Xf = n2 / this.Hf;
        this.Yf = n / this.Vf;
    }

    public void setQuantizationTable(int[] nArray) {
        this.qt = nArray;
    }

    public void setHuffmanTables(JPEGHuffmanInputStream jPEGHuffmanInputStream, JPEGHuffmanInputStream jPEGHuffmanInputStream2) {
        this.in = new JPEGFastDCTInputStream(jPEGHuffmanInputStream, jPEGHuffmanInputStream2, this.qt, this.bps);
    }

    public void restart() throws IOException {
        this.in.restart();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    protected void copyPixel(int[] nArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                nArray[n + j] = nArray[n + j] | n4 << this.shift;
            }
            n += this.width;
        }
    }

    protected void copyDataUnit(int[] nArray, int n, int n2, int n3, int[] nArray2) throws IOException {
        int n4 = 0;
        int n5 = n;
        for (int i = 0; i < n2; i += this.Yf) {
            int n6;
            for (n6 = 0; n6 < n3; n6 += this.Xf) {
                this.copyPixel(nArray, n5 + n6, n2 - i >= this.Yf ? this.Yf : n2 & this.Yf - 1, n3 - n6 >= this.Xf ? this.Xf : n3 & this.Xf - 1, nArray2[n4++]);
            }
            while (n6 < 8 * this.Xf) {
                ++n4;
                n6 += this.Xf;
            }
            n5 += this.width * this.Yf;
        }
    }

    public void read(int[] nArray, int n, int n2, int n3) throws IOException {
        int n4 = n;
        int n5 = 0;
        for (int i = 0; i < this.Vf; ++i) {
            int n6 = n4;
            int n7 = 0;
            for (int j = 0; j < this.Hf; ++j) {
                this.in.fillBuffer();
                if (n5 < n2 && n7 < n3) {
                    this.copyDataUnit(nArray, n6, n2 - n5 >= 8 * this.Yf ? 8 * this.Yf : n2 & 8 * this.Yf - 1, n3 - n7 >= 8 * this.Xf ? 8 * this.Xf : n3 & 8 * this.Xf - 1, this.in.getBuffer());
                }
                n6 += 8 * this.Xf;
                n7 += 8 * this.Xf;
            }
            n4 += this.width * 8 * this.Yf;
            n5 += 8 * this.Yf;
        }
    }

    protected void copyPixel(byte[] byArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                byArray[n + j] = (byte)n4;
            }
            n += this.width;
        }
    }

    protected void copyDataUnit(byte[] byArray, int n, int n2, int n3, int[] nArray) throws IOException {
        int n4 = 0;
        int n5 = n;
        for (int i = 0; i < n2; i += this.Yf) {
            int n6;
            for (n6 = 0; n6 < n3; n6 += this.Xf) {
                this.copyPixel(byArray, n5 + n6, n2 - i >= this.Yf ? this.Yf : n2 & this.Yf - 1, n3 - n6 >= this.Xf ? this.Xf : n3 & this.Xf - 1, nArray[n4++]);
            }
            while (n6 < 8 * this.Xf) {
                ++n4;
                n6 += this.Xf;
            }
            n5 += this.width * this.Yf;
        }
    }

    public void read(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = n;
        int n5 = 0;
        for (int i = 0; i < this.Vf; ++i) {
            int n6 = n4;
            int n7 = 0;
            for (int j = 0; j < this.Hf; ++j) {
                this.in.fillBuffer();
                if (n5 < n2 && n7 < n3) {
                    this.copyDataUnit(byArray, n6, n2 - n5 >= 8 * this.Yf ? 8 * this.Yf : n2 & 8 * this.Yf - 1, n3 - n7 >= 8 * this.Xf ? 8 * this.Xf : n3 & 8 * this.Xf - 1, this.in.getBuffer());
                }
                n6 += 8 * this.Xf;
                n7 += 8 * this.Xf;
            }
            n4 += this.width * 8 * this.Yf;
            n5 += 8 * this.Yf;
        }
    }

    public String toString() {
        String string = "";
        string = string + "id  =" + this.id + "\n";
        string = string + "bps =" + this.bps + "\n";
        string = string + "Hf  =" + this.Hf + "\n";
        string = string + "Vf  =" + this.Vf + "\n";
        string = string + "HMax  =" + this.HMax + "\n";
        string = string + "VMax  =" + this.VMax + "\n";
        string = string + "Yf  =" + this.Yf + "\n";
        string = string + "Xf  =" + this.Xf + "\n";
        return string;
    }
}

