/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JPEGBitOutputStream
extends FilterOutputStream {
    private int bitBuffer;
    private int bitCount = 0;

    public JPEGBitOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeBit(int n) throws IOException {
        this.writeBits(n & 1, 1);
    }

    public void writeBits(int n, int n2) throws IOException {
        this.bitCount += n2;
        this.bitBuffer |= (n &= ~(-1 << n2)) << 32 - this.bitCount;
        while (this.bitCount >= 8) {
            int n3 = this.bitBuffer >>> 24 & 0xFF;
            this.out.write(n3);
            if (n3 == 255) {
                this.out.write(0);
            }
            this.bitBuffer <<= 8;
            this.bitCount -= 8;
        }
    }

    public void flush() throws IOException {
        if (this.bitCount > 0) {
            this.writeBits(-1, 8 - this.bitCount);
        }
        this.out.flush();
    }
}

