/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGConstants;
import uk.co.mmscomputing.imageio.jpeg.JPEGHuffmanOutputStream;

public class JPEGACOutputStream
extends OutputStream
implements JPEGConstants {
    private JPEGHuffmanOutputStream out;
    private int K;
    private int R;

    public JPEGACOutputStream(JPEGHuffmanOutputStream jPEGHuffmanOutputStream) {
        this.out = jPEGHuffmanOutputStream;
        this.K = 1;
        this.R = 0;
    }

    public void write(int n) throws IOException {
        if (n == 0) {
            ++this.R;
        } else {
            while (this.R >= 16) {
                this.out.write(240);
                this.R -= 16;
            }
            int n2 = 1;
            if (n > 0) {
                while ((-1 << n2 & n) != 0) {
                    ++n2;
                }
            } else {
                n = -n;
                while ((-1 << n2 & n) != 0) {
                    ++n2;
                }
                n = -n - 1;
            }
            this.out.write(this.R << 4 | (n2 &= 0xF));
            this.out.writeBits(n, n2);
            this.R = 0;
        }
        ++this.K;
        if (this.K == 64) {
            if (this.R > 0) {
                this.out.write(0);
            }
            this.K = 1;
            this.R = 0;
        }
    }
}

