/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGConstants;
import uk.co.mmscomputing.imageio.jpeg.JPEGHuffmanInputStream;

public class JPEGACInputStream
extends InputStream
implements JPEGConstants {
    protected JPEGHuffmanInputStream in;
    protected int[] qt;
    protected int count;
    protected int[] buffer = new int[64];

    public JPEGACInputStream(JPEGHuffmanInputStream jPEGHuffmanInputStream, int[] nArray) {
        this.in = jPEGHuffmanInputStream;
        this.qt = nArray;
        this.count = 64;
    }

    public void restart() throws IOException {
        this.in.restart();
        this.count = 64;
    }

    public void fillBuffer() throws IOException {
        int n = 1;
        for (int i = 1; i < 64; ++i) {
            this.buffer[i] = 0;
        }
        while (n < 64) {
            int n2 = this.in.read();
            if (n2 == -1) {
                throw new IOException(this.getClass().getName() + "fillBuffer:\n\tUnexpected end of file.");
            }
            int n3 = n2 & 0xF;
            int n4 = n2 >> 4 & 0xF;
            if (n3 == 0) {
                if (n4 != 15) break;
                n += 16;
                continue;
            }
            this.buffer[JPEGACInputStream.IZigZagTable[n += n4]] = this.qt[n] * this.in.readBits(n3);
            ++n;
        }
    }

    public int read() throws IOException {
        if (this.count == 64) {
            this.fillBuffer();
            this.count = 1;
        }
        return this.buffer[this.count++];
    }
}

