/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGConstants;
import uk.co.mmscomputing.imageio.jpeg.JPEGOutputStream;

public class JFIFOutputStream
extends JPEGOutputStream {
    protected int version = 258;
    protected int units = 0;
    protected int xDensity = 1;
    protected int yDensity = 1;
    protected int xThumbnail = 0;
    protected int yThumbnail = 0;

    public JFIFOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    public JFIFOutputStream(OutputStream outputStream, boolean bl) throws IOException {
        super(outputStream);
        this.setZZQuantizationTable(0, JPEGConstants.LQT2);
        this.setRawDCHuffmanTable(0, JPEGConstants.HLDCTable);
        this.setRawACHuffmanTable(0, JPEGConstants.HLACTable);
        if (bl) {
            this.setZZQuantizationTable(1, JPEGConstants.CQT2);
            this.setRawDCHuffmanTable(1, JPEGConstants.HCDCTable);
            this.setRawACHuffmanTable(1, JPEGConstants.HCACTable);
        }
    }

    public JFIFOutputStream(OutputStream outputStream, boolean bl, int n, int n2) throws IOException {
        super(outputStream);
        System.out.println("3\b" + this.getClass().getName() + "\n\tMMSC-JPEG Encoder.");
        this.app0(outputStream);
        this.setZZQuantizationTable(0, JPEGConstants.LQT2);
        this.setRawDCHuffmanTable(0, JPEGConstants.HLDCTable);
        this.setRawACHuffmanTable(0, JPEGConstants.HLACTable);
        if (bl) {
            this.setZZQuantizationTable(1, JPEGConstants.CQT2);
            this.setRawDCHuffmanTable(1, JPEGConstants.HCDCTable);
            this.setRawACHuffmanTable(1, JPEGConstants.HCACTable);
            this.defineQuantizationTables();
            this.defineHuffmanTables();
            int[] nArray = new int[]{34, 17, 17};
            int[] nArray2 = new int[]{0, 1, 1};
            this.startOfFrame(n, n2, nArray, nArray2);
            int[] nArray3 = new int[]{0, 1, 1};
            this.startOfScan(nArray3);
        } else {
            this.defineQuantizationTables();
            this.defineHuffmanTables();
            int[] nArray = new int[]{17};
            int[] nArray4 = new int[]{0};
            this.startOfFrame(n, n2, nArray, nArray4);
            int[] nArray5 = new int[]{0};
            this.startOfScan(nArray5);
        }
    }

    public void setUnits(int n) {
        this.units = n;
    }

    public int getUnits() {
        return this.units;
    }

    public void setXDensity(int n) {
        this.xDensity = n;
    }

    public int getXDensity() {
        return this.xDensity;
    }

    public void setYDensity(int n) {
        this.yDensity = n;
    }

    public int getYDensity() {
        return this.yDensity;
    }

    protected void app0(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(74);
        byteArrayOutputStream.write(70);
        byteArrayOutputStream.write(73);
        byteArrayOutputStream.write(70);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(this.version >> 8 & 0xFF);
        byteArrayOutputStream.write(this.version & 0xFF);
        byteArrayOutputStream.write(this.units);
        byteArrayOutputStream.write(this.xDensity >> 8 & 0xFF);
        byteArrayOutputStream.write(this.xDensity & 0xFF);
        byteArrayOutputStream.write(this.yDensity >> 8 & 0xFF);
        byteArrayOutputStream.write(this.yDensity & 0xFF);
        byteArrayOutputStream.write(this.xThumbnail);
        byteArrayOutputStream.write(this.yThumbnail);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n = byArray.length + 2;
        outputStream.write(255);
        outputStream.write(224);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n & 0xFF);
        outputStream.write(byArray);
    }

    public void writeHeader(OutputStream outputStream, int n, int n2) throws IOException {
        this.app0(outputStream);
        this.defineQuantizationTables();
        this.defineHuffmanTables();
        int[] nArray = new int[]{34, 17, 17};
        int[] nArray2 = new int[]{0, 1, 1};
        this.startOfFrame(n, n2, nArray, nArray2);
        int[] nArray3 = new int[]{0, 1, 1};
        this.startOfScan(nArray3);
    }

    protected int convert(int n) {
        double d = n >> 16 & 0xFF;
        double d2 = n >> 8 & 0xFF;
        double d3 = n & 0xFF;
        int n2 = (int)(0.299 * d + 0.587 * d2 + 0.114 * d3);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        int n3 = (int)(-0.168736 * d - 0.331264 * d2 + 0.5 * d3 + 128.0);
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        int n4 = (int)(0.5 * d - 0.4186876 * d2 - 0.08131241 * d3 + 128.0);
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > 255) {
            n4 = 255;
        }
        return n2 << 16 | n3 << 8 | n4;
    }

    public void write(int n) throws IOException {
        n = this.convert(n);
        super.write(n >> 16 & 0xFF);
        super.write(n >> 8 & 0xFF);
        super.write(n & 0xFF);
    }

    public void write(int[] nArray) throws IOException {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.write(nArray[i]);
        }
    }

    public void write(int[] nArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(nArray[n + i]);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            super.write(byArray[n + i]);
        }
    }
}

