/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGInputStream;

public class JFIFInputStream
extends JPEGInputStream {
    protected int version;
    protected int units;
    protected int xDensity;
    protected int yDensity;
    protected int xThumbnail;
    protected int yThumbnail;

    public JFIFInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public int getUnits() {
        return this.units;
    }

    public int getXDensity() {
        return this.xDensity;
    }

    public int getYDensity() {
        return this.yDensity;
    }

    public void app0(InputStream inputStream) throws IOException {
        String string = "";
        for (int i = 0; i < 5; ++i) {
            string = string + (char)this.readIn(inputStream);
        }
        if (string.equals("JFIF\u0000")) {
            this.version = this.readIn(inputStream) << 8 | this.readIn(inputStream);
            this.units = this.readIn(inputStream);
            this.xDensity = this.readIn(inputStream) << 8 | this.readIn(inputStream);
            this.yDensity = this.readIn(inputStream) << 8 | this.readIn(inputStream);
            this.xThumbnail = this.readIn(inputStream);
            this.yThumbnail = this.readIn(inputStream);
        } else if (string.equals("JFXX\u0000")) {
            // empty if block
        }
    }

    public void app1(InputStream inputStream) throws IOException {
        String string = "";
        for (int i = 0; i < 6; ++i) {
            string = string + (char)this.readIn(inputStream);
        }
        System.out.println("ID=" + string);
        if (string.equals("Exif\u0000\u0000")) {
            // empty if block
        }
    }

    public void app2(InputStream inputStream) throws IOException {
        int n;
        String string = "";
        int n2 = 0;
        while ((n = (int)inputStream.read()) != -1) {
            string = string + (char)n;
            System.out.println("APP2[" + n2 + "] 0x" + Integer.toHexString(n) + " " + (char)(n >= 32 ? n : 32) + " " + n);
            ++n2;
            if (!string.equals("ICC_PROFILE\u0000")) continue;
            break;
        }
    }

    public void app13(InputStream inputStream) throws IOException {
        int n;
        String string = "";
        int n2 = 0;
        while ((n = (int)inputStream.read()) != -1) {
            string = string + (char)n;
            System.out.println("APP13[" + n2 + "] 0x" + Integer.toHexString(n) + " " + (char)(n >= 32 ? n : 32) + " " + n);
            ++n2;
            if (!string.equals("Photoshop 3.0\u0000")) continue;
            break;
        }
    }

    public void app14(InputStream inputStream) throws IOException {
        int n;
        String string = "";
        int n2 = 0;
        while ((n = (int)inputStream.read()) != -1) {
            string = string + (char)n;
            System.out.println("APP14[" + n2 + "] 0x" + Integer.toHexString(n) + " " + (char)(n >= 32 ? n : 32) + " " + n);
            ++n2;
            if (!string.equals("Adobe\u0000")) continue;
            break;
        }
    }

    public int read(int[] nArray, int n, int n2) throws IOException {
        n2 = super.read(nArray, n, n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            double d = n3 >> 16 & 0xFF;
            double d2 = n3 >> 8 & 0xFF;
            double d3 = n3 & 0xFF;
            int n4 = (int)(d + 1.402 * (d3 - 128.0));
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            int n5 = (int)(d - 0.3441363 * (d2 - 128.0) - 0.71413636 * (d3 - 128.0));
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 > 255) {
                n5 = 255;
            }
            int n6 = (int)(d + 1.772 * (d2 - 128.0));
            if (n6 < 0) {
                n6 = 0;
            } else if (n6 > 255) {
                n6 = 255;
            }
            nArray[i] = n4 << 16 | n5 << 8 | n6;
        }
        return n2;
    }
}

